<?php
// pages/transaction_detail.php
include '../config/database.php';
include '../includes/header.php';

// Check if code parameter is set
if (!isset($_GET['code'])) {
    echo "<script>alert('Kode transaksi tidak valid.'); window.history.back();</script>";
    exit;
}

$transaction_code = escape($_GET['code']);

// Get transaction data
$transaction_query = query("SELECT t.*, c.name as customer_name, c.phone as customer_phone, c.email as customer_email, 
                           u.name as cashier_name 
                           FROM transactions t 
                           LEFT JOIN customers c ON t.customer_id = c.id 
                           LEFT JOIN users u ON t.user_id = u.id 
                           WHERE t.transaction_code = '$transaction_code'");
$transaction = $transaction_query->fetch_assoc();

if (!$transaction) {
    echo "<script>alert('Transaksi tidak ditemukan.'); window.history.back();</script>";
    exit;
}

// Get transaction items
$items_query = query("SELECT ti.*, p.name as product_name, p.sku as product_sku, p.type as product_type 
                      FROM transaction_items ti 
                      LEFT JOIN products p ON ti.product_id = p.id 
                      WHERE ti.transaction_id = '{$transaction['id']}'");

// Hitung total amount dari items
$total_amount_from_items = 0;
$temp_items = query("SELECT SUM(subtotal) as total FROM transaction_items WHERE transaction_id = '{$transaction['id']}'");
if ($temp_items && $temp_row = $temp_items->fetch_assoc()) {
    $total_amount_from_items = $temp_row['total'];
}
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0"><i class="fas fa-receipt me-2"></i>Detail Transaksi</h4>
                        <div class="d-flex gap-2">
                            <a href="print_transaction.php?code=<?php echo $transaction_code; ?>" 
                               class="btn btn-light btn-sm" target="_blank">
                                <i class="fas fa-print me-1"></i>Cetak
                            </a>
                            <a href="transactions.php" class="btn btn-success btn-sm">
                                <i class="fas fa-plus me-1"></i>Transaksi Baru
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Transaction Info -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Informasi Transaksi</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-borderless table-sm">
                                        <tr>
                                            <th width="40%" class="text-muted">Kode Transaksi</th>
                                            <td><strong class="text-primary"><?php echo $transaction['transaction_code']; ?></strong></td>
                                        </tr>
                                        <tr>
                                            <th class="text-muted">Tanggal</th>
                                            <td><?php echo date('d/m/Y H:i', strtotime($transaction['created_at'])); ?></td>
                                        </tr>
                                        <tr>
                                            <th class="text-muted">Status</th>
                                            <td>
                                                <span class="badge bg-<?php echo $transaction['transaction_status'] == 'completed' ? 'success' : 'warning'; ?>">
                                                    <?php echo ucfirst($transaction['transaction_status']); ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th class="text-muted">Kasir</th>
                                            <td><?php echo $transaction['cashier_name']; ?></td>
                                        </tr>
                                        <tr>
                                            <th class="text-muted">Metode Pembayaran</th>
                                            <td>
                                                <span class="badge bg-info">
                                                    <?php 
                                                    $payment_methods = [
                                                        'cash' => '💵 Tunai',
                                                        'transfer' => '🏦 Transfer',
                                                        'debit_card' => '💳 Kartu Debit',
                                                        'credit_card' => '💳 Kartu Kredit',
                                                        'e_wallet' => '📱 E-Wallet'
                                                    ];
                                                    echo $payment_methods[$transaction['payment_method']] ?? ucfirst($transaction['payment_method']);
                                                    ?>
                                                </span>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0"><i class="fas fa-user me-2"></i>Informasi Customer</h6>
                                </div>
                                <div class="card-body">
                                    <table class="table table-borderless table-sm">
                                        <tr>
                                            <th width="40%" class="text-muted">Nama</th>
                                            <td><strong><?php echo $transaction['customer_name'] ?: 'Walk-in Customer'; ?></strong></td>
                                        </tr>
                                        <?php if ($transaction['customer_phone']): ?>
                                        <tr>
                                            <th class="text-muted">Telepon</th>
                                            <td><?php echo $transaction['customer_phone']; ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <?php if ($transaction['customer_email']): ?>
                                        <tr>
                                            <th class="text-muted">Email</th>
                                            <td><?php echo $transaction['customer_email']; ?></td>
                                        </tr>
                                        <?php endif; ?>
                                        <tr>
                                            <th class="text-muted">Catatan</th>
                                            <td><?php echo $transaction['notes'] ?: '-'; ?></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Items Table -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h6 class="mb-0"><i class="fas fa-list me-2"></i>Daftar Item</h6>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-hover mb-0">
                                            <thead class="table-light">
                                                <tr>
                                                    <th width="5%">#</th>
                                                    <th width="35%">Produk/Layanan</th>
                                                    <th width="15%">Tipe</th>
                                                    <th width="15%" class="text-center">Harga</th>
                                                    <th width="10%" class="text-center">Qty</th>
                                                    <th width="20%" class="text-end">Subtotal</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $no = 1;
                                                $total_amount = 0;
                                                while ($item = $items_query->fetch_assoc()):
                                                    $subtotal = $item['quantity'] * $item['product_price'];
                                                    $total_amount += $subtotal;
                                                ?>
                                                <tr>
                                                    <td class="text-muted"><?php echo $no++; ?></td>
                                                    <td>
                                                        <div>
                                                            <strong><?php echo $item['product_name']; ?></strong>
                                                            <?php if ($item['product_sku']): ?>
                                                            <br><small class="text-muted">SKU: <?php echo $item['product_sku']; ?></small>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-<?php 
                                                            $type_colors = [
                                                                'sparepart' => 'primary',
                                                                'service' => 'success',
                                                                'food' => 'warning',
                                                                'beverage' => 'info'
                                                            ];
                                                            echo $type_colors[$item['product_type']] ?? 'secondary';
                                                        ?>">
                                                            <?php 
                                                            $type_names = [
                                                                'sparepart' => 'Sparepart',
                                                                'service' => 'Layanan',
                                                                'food' => 'Makanan',
                                                                'beverage' => 'Minuman'
                                                            ];
                                                            echo $type_names[$item['product_type']] ?? $item['product_type'];
                                                            ?>
                                                        </span>
                                                    </td>
                                                    <td class="text-center">Rp <?php echo number_format($item['product_price'], 0, ',', '.'); ?></td>
                                                    <td class="text-center"><?php echo $item['quantity']; ?></td>
                                                    <td class="text-end"><strong>Rp <?php echo number_format($subtotal, 0, ',', '.'); ?></strong></td>
                                                </tr>
                                                <?php endwhile; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Summary -->
                    <div class="row mt-4">
                        <div class="col-md-6 offset-md-6">
                            <div class="card border-0 bg-light">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="text-muted">Subtotal:</span>
                                        <span class="fw-bold">Rp <?php echo number_format($total_amount_from_items, 0, ',', '.'); ?></span>
                                    </div>
                                    <?php if ($transaction['discount_amount'] > 0): ?>
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="text-danger">Diskon:</span>
                                        <span class="text-danger fw-bold">- Rp <?php echo number_format($transaction['discount_amount'], 0, ',', '.'); ?></span>
                                    </div>
                                    <?php endif; ?>
                                    <hr>
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="h5 mb-0">Total:</span>
                                        <span class="h4 mb-0 text-primary fw-bold">Rp <?php echo number_format($transaction['final_amount'], 0, ',', '.'); ?></span>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-muted">Jumlah Bayar:</span>
                                        <span class="fw-bold">Rp <?php echo number_format($transaction['payment_amount'], 0, ',', '.'); ?></span>
                                    </div>
                                    <?php if ($transaction['payment_method'] == 'cash' && $transaction['change_amount'] > 0): ?>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-muted">Kembalian:</span>
                                        <span class="fw-bold text-success">Rp <?php echo number_format($transaction['change_amount'], 0, ',', '.'); ?></span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex gap-2 justify-content-end">
                                <a href="javascript:window.history.back()" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-2"></i>Kembali
                                </a>
                                <a href="../index.php" class="btn btn-outline-primary">
                                    <i class="fas fa-home me-2"></i>Dashboard
                                </a>
                                <a href="print_transaction.php?code=<?php echo $transaction_code; ?>" 
                                   class="btn btn-primary" target="_blank">
                                    <i class="fas fa-print me-2"></i>Cetak Ulang
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>