<?php
// pages/products.php
ob_start(); // Start output buffering

// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include '../config/database.php';
    
    // Start session untuk memastikan session tersedia
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    $id = escape($_POST['id'] ?? '');
    $barcode = escape($_POST['barcode']);
    $name = escape($_POST['name']);
    $type = escape($_POST['type']);
    $category_id = escape($_POST['category_id'] ?: 'NULL');
    $purchase_price = escape($_POST['purchase_price']);
    $selling_price = escape($_POST['selling_price']);
    $stock = escape($_POST['stock']);
    $min_stock = escape($_POST['min_stock']);
    $unit = escape($_POST['unit']);
    $description = escape($_POST['description']);

    // Validasi required fields
    if (empty($name) || empty($type) || empty($selling_price)) {
        $_SESSION['error'] = "Nama produk, jenis produk, dan harga jual harus diisi!";
        ob_end_clean(); // Clear buffer before redirect
        header("Location: products.php");
        exit();
    }

    // Validasi duplicate barcode
    if (!empty($barcode)) {
        $check_barcode_sql = "SELECT id FROM products WHERE barcode = '$barcode'";
        if (!empty($id)) {
            $check_barcode_sql .= " AND id != '$id'";
        }
        $barcode_result = query($check_barcode_sql);
        if ($barcode_result->num_rows > 0) {
            $_SESSION['error'] = "Barcode sudah digunakan oleh produk lain!";
            ob_end_clean(); // Clear buffer before redirect
            header("Location: products.php");
            exit();
        }
    }

    // Set default values
    $sku = "SKU" . date('YmdHis') . rand(100, 999);
    $weight = 0;
    $compatibility = '';
    $serial_number = '';
    $is_has_variant = 0;
    $preparation_time = 0;
    $image_path = 'NULL';

    // Handle NULL values
    $barcode_value = empty($barcode) ? 'NULL' : "'$barcode'";
    $category_value = ($category_id === 'NULL') ? 'NULL' : "'$category_id'";

    if (empty($id)) {
        // Add new product
        $sql = "INSERT INTO products (
            barcode, sku, name, type, category_id, purchase_price, selling_price, 
            stock, min_stock, unit, weight, compatibility, serial_number, 
            is_has_variant, preparation_time, description, image_path
        ) VALUES (
            $barcode_value, '$sku', '$name', '$type', $category_value, 
            '$purchase_price', '$selling_price', '$stock', '$min_stock', 
            '$unit', '$weight', '$compatibility', '$serial_number', 
            '$is_has_variant', '$preparation_time', '$description', $image_path
        )";
    } else {
        // Update product
        $sql = "UPDATE products SET 
            barcode = $barcode_value,
            name = '$name',
            type = '$type',
            category_id = $category_value,
            purchase_price = '$purchase_price',
            selling_price = '$selling_price',
            stock = '$stock',
            min_stock = '$min_stock',
            unit = '$unit',
            description = '$description'
            WHERE id = '$id'";
    }

    if (query($sql)) {
        $_SESSION['success'] = empty($id) ? "Produk berhasil ditambahkan!" : "Produk berhasil diupdate!";
    } else {
        $_SESSION['error'] = "Gagal menyimpan produk! Error: " . mysqli_error($connection);
    }
    
    ob_end_clean(); // Clear buffer before redirect
    header("Location: products.php");
    exit();
}

// Process delete - PERBAIKAN UTAMA DI SINI
if (isset($_GET['delete'])) {
    include '../config/database.php';
    
    // Start session untuk memastikan session tersedia
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    
    $delete_id = escape($_GET['delete']);
    
    // Debug: Cek apakah parameter delete diterima
    error_log("Delete request for product ID: " . $delete_id);
    
    // Check if product has transactions
    $check_sql = "SELECT COUNT(*) as count FROM transaction_items WHERE product_id = '$delete_id'";
    $check_result = query($check_sql);
    
    if ($check_result && $check_result->num_rows > 0) {
        $check_data = $check_result->fetch_assoc();
        if ($check_data['count'] > 0) {
            $_SESSION['error'] = "Produk tidak dapat dihapus karena sudah memiliki transaksi!";
            error_log("Product has transactions, cannot delete");
        } else {
            // Gunakan soft delete (update is_active = 0) bukan hard delete
            $sql = "UPDATE products SET is_active = 0 WHERE id = '$delete_id'";
            
            if (query($sql)) {
                $_SESSION['success'] = "Produk berhasil dihapus!";
                error_log("Product deleted successfully: " . $delete_id);
            } else {
                $_SESSION['error'] = "Gagal menghapus produk! Error: " . mysqli_error($connection);
                error_log("Failed to delete product: " . mysqli_error($connection));
            }
        }
    } else {
        $_SESSION['error'] = "Gagal memeriksa transaksi produk!";
        error_log("Failed to check product transactions");
    }
    
    ob_end_clean(); // Clear buffer before redirect
    header("Location: products.php");
    exit();
}

// NORMAL PAGE LOAD
include '../config/database.php';
include '../includes/header.php';

// Get data dengan search dan filter
$search = $_GET['search'] ?? '';
$filter_type = $_GET['type'] ?? '';
$filter_stock = $_GET['stock'] ?? '';

$where_conditions = ["p.is_active = 1"];
$params = [];

if (!empty($search)) {
    $where_conditions[] = "(p.name LIKE '%$search%' OR p.barcode LIKE '%$search%')";
}

if (!empty($filter_type)) {
    $where_conditions[] = "p.type = '$filter_type'";
}

if (!empty($filter_stock)) {
    if ($filter_stock === 'low') {
        $where_conditions[] = "p.stock <= p.min_stock AND p.stock > 0 AND p.type != 'service'";
    } elseif ($filter_stock === 'out') {
        $where_conditions[] = "p.stock = 0 AND p.type != 'service'";
    } elseif ($filter_stock === 'available') {
        $where_conditions[] = "p.stock > p.min_stock AND p.type != 'service'";
    }
}

$where_sql = implode(' AND ', $where_conditions);

$products = query("SELECT p.*, c.name as category_name 
                  FROM products p 
                  LEFT JOIN categories c ON p.category_id = c.id 
                  WHERE $where_sql 
                  ORDER BY p.name");

// Query categories tanpa kondisi is_active
$categories = query("SELECT * FROM categories ORDER BY name");

// Get stats
$total_products = query("SELECT COUNT(*) as total FROM products WHERE is_active = 1")->fetch_assoc()['total'];
$low_stock = query("SELECT COUNT(*) as total FROM products WHERE stock <= min_stock AND stock > 0 AND type != 'service' AND is_active = 1")->fetch_assoc()['total'];
$out_of_stock = query("SELECT COUNT(*) as total FROM products WHERE stock = 0 AND type != 'service' AND is_active = 1")->fetch_assoc()['total'];
$services = query("SELECT COUNT(*) as total FROM products WHERE type = 'service' AND is_active = 1")->fetch_assoc()['total'];
?>

<div class="container-fluid">
    <!-- PERBAIKAN: Pindahkan alert messages ke dalam container-fluid -->
    <?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show mt-3">
        <i class="fas fa-check-circle me-2"></i><?php echo $_SESSION['success']; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['success']); endif;?>

    <?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show mt-3">
        <i class="fas fa-exclamation-circle me-2"></i><?php echo $_SESSION['error']; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['error']); endif;?>

    <!-- Sisanya sama seperti sebelumnya -->
    <!-- Stats Grid -->
    <div class="stats-grid mb-4">
        <div class="stat-card primary">
            <div class="stat-icon">
                <i class="fas fa-boxes"></i>
            </div>
            <div class="stat-value"><?php echo $total_products; ?></div>
            <div class="stat-label">Total Produk</div>
        </div>
        
        <div class="stat-card warning">
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stat-value"><?php echo $low_stock; ?></div>
            <div class="stat-label">Stok Rendah</div>
        </div>
        
        <div class="stat-card danger">
            <div class="stat-icon">
                <i class="fas fa-times-circle"></i>
            </div>
            <div class="stat-value"><?php echo $out_of_stock; ?></div>
            <div class="stat-label">Stok Habis</div>
        </div>
        
        <div class="stat-card success">
            <div class="stat-icon">
                <i class="fas fa-concierge-bell"></i>
            </div>
            <div class="stat-value"><?php echo $services; ?></div>
            <div class="stat-label">Jasa/Layanan</div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="fas fa-list me-2"></i>Daftar Produk</h5>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#productModal" onclick="resetForm()">
                            <i class="fas fa-plus me-2"></i>Tambah Produk
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Search and Filters -->
                    <form method="GET" id="searchForm">
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-search"></i></span>
                                    <input type="text" name="search" class="form-control" placeholder="Cari produk atau barcode..." value="<?php echo htmlspecialchars($search); ?>">
                                    <button type="submit" class="btn btn-primary">Cari</button>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="type" onchange="this.form.submit()">
                                    <option value="">Semua Jenis</option>
                                    <option value="sparepart" <?php echo $filter_type === 'sparepart' ? 'selected' : ''; ?>>Sparepart</option>
                                    <option value="service" <?php echo $filter_type === 'service' ? 'selected' : ''; ?>>Jasa</option>
                                    <option value="food" <?php echo $filter_type === 'food' ? 'selected' : ''; ?>>Makanan</option>
                                    <option value="beverage" <?php echo $filter_type === 'beverage' ? 'selected' : ''; ?>>Minuman</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="stock" onchange="this.form.submit()">
                                    <option value="">Semua Stok</option>
                                    <option value="low" <?php echo $filter_stock === 'low' ? 'selected' : ''; ?>>Stok Rendah</option>
                                    <option value="out" <?php echo $filter_stock === 'out' ? 'selected' : ''; ?>>Stok Habis</option>
                                    <option value="available" <?php echo $filter_stock === 'available' ? 'selected' : ''; ?>>Stok Tersedia</option>
                                </select>
                            </div>
                        </div>
                    </form>

                    <!-- Products Table -->
                    <div class="table-responsive">
                        <table class="table table-hover" id="productsTable">
                            <thead>
                                <tr>
                                    <th>Kode</th>
                                    <th>Produk</th>
                                    <th>Kategori</th>
                                    <th>Jenis</th>
                                    <th>Harga</th>
                                    <th>Stok</th>
                                    <th>Status</th>
                                    <th width="120">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if ($products->num_rows > 0): ?>
                                <?php while ($product = $products->fetch_assoc()): 
                                    $stock_status = getStockStatus($product);
                                    $status_class = getStatusClass($stock_status);
                                ?>
                                <tr class="<?php echo $status_class; ?>">
                                    <td>
                                        <?php if (!empty($product['barcode'])): ?>
                                        <small class="text-muted"><?php echo $product['barcode']; ?></small>
                                        <?php else: ?>
                                        <small class="text-muted">-</small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="product-icon me-3">
                                                <i class="fas fa-<?php echo getProductIcon($product['type']); ?> text-<?php echo getTypeColor($product['type']); ?>"></i>
                                            </div>
                                            <div>
                                                <h6 class="mb-1 fw-bold"><?php echo $product['name']; ?></h6>
                                                <small class="text-muted">SKU: <?php echo $product['sku']; ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo $product['category_name'] ?: '<span class="text-muted">-</span>'; ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo getTypeColor($product['type']); ?>">
                                            <?php echo ucfirst($product['type']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <strong class="text-primary">Rp <?php echo number_format($product['selling_price'], 0, ',', '.'); ?></strong>
                                        <?php if ($product['purchase_price'] > 0): ?>
                                        <br><small class="text-muted">Beli: Rp <?php echo number_format($product['purchase_price'], 0, ',', '.'); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($product['type'] == 'service'): ?>
                                            <span class="text-muted">-</span>
                                        <?php else: ?>
                                            <div class="d-flex align-items-center">
                                                <span class="fw-bold me-2"><?php echo $product['stock']; ?></span>
                                                <small class="text-muted"><?php echo $product['unit']; ?></small>
                                            </div>
                                            <?php if ($product['min_stock'] > 0): ?>
                                            <small class="text-muted">Min: <?php echo $product['min_stock']; ?></small>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($product['type'] !== 'service'): ?>
                                        <span class="badge bg-<?php echo $status_class == 'low-stock' ? 'warning' : ($status_class == 'out-of-stock' ? 'danger' : 'success'); ?>">
                                            <?php echo $stock_status; ?>
                                        </span>
                                        <?php else: ?>
                                        <span class="badge bg-success">Aktif</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <button class="btn btn-outline-primary" onclick="editProduct(<?php echo $product['id']; ?>)" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-outline-danger" onclick="confirmDelete(<?php echo $product['id']; ?>, '<?php echo addslashes($product['name']); ?>')" title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                                <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center py-5">
                                        <i class="fas fa-box-open fa-4x text-muted mb-3"></i>
                                        <h5 class="text-muted">Tidak ada produk ditemukan</h5>
                                        <p class="text-muted">Coba ubah filter pencarian atau tambahkan produk baru.</p>
                                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#productModal" onclick="resetForm()">
                                            <i class="fas fa-plus me-2"></i>Tambah Produk
                                        </button>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Product Modal -->
<div class="modal fade" id="productModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalTitle">Tambah Produk Baru</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" id="productForm" onsubmit="return validateForm()">
                <input type="hidden" name="id" id="productId">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="barcode" class="form-label">Barcode</label>
                            <input type="text" class="form-control" id="barcode" name="barcode" placeholder="Kode barcode (opsional)">
                            <div class="form-text">Biarkan kosong untuk generate otomatis</div>
                        </div>
                        <div class="col-md-6">
                            <label for="name" class="form-label">Nama Produk <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                    </div>

                    <div class="row g-3 mt-2">
                        <div class="col-md-6">
                            <label for="type" class="form-label">Jenis Produk <span class="text-danger">*</span></label>
                            <select class="form-select" id="type" name="type" required onchange="toggleStockFields()">
                                <option value="">-- Pilih Jenis --</option>
                                <option value="sparepart">Sparepart</option>
                                <option value="service">Jasa/Layanan</option>
                                <option value="food">Makanan</option>
                                <option value="beverage">Minuman</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="category_id" class="form-label">Kategori</label>
                            <select class="form-select" id="category_id" name="category_id">
                                <option value="">-- Pilih Kategori --</option>
                                <?php 
                                $categories->data_seek(0); // Reset pointer
                                while ($category = $categories->fetch_assoc()): ?>
                                <option value="<?php echo $category['id']; ?>"><?php echo $category['name']; ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>

                    <div class="row g-3 mt-2">
                        <div class="col-md-6">
                            <label for="purchase_price" class="form-label">Harga Beli</label>
                            <input type="number" class="form-control" id="purchase_price" name="purchase_price" value="0" min="0" step="100">
                        </div>
                        <div class="col-md-6">
                            <label for="selling_price" class="form-label">Harga Jual <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" id="selling_price" name="selling_price" required min="0" step="100">
                        </div>
                    </div>

                    <div class="row g-3 mt-2" id="stockFields">
                        <div class="col-md-4">
                            <label for="stock" class="form-label">Stok Awal</label>
                            <input type="number" class="form-control" id="stock" name="stock" value="0" min="0">
                        </div>
                        <div class="col-md-4">
                            <label for="min_stock" class="form-label">Stok Minimum</label>
                            <input type="number" class="form-control" id="min_stock" name="min_stock" value="0" min="0">
                        </div>
                        <div class="col-md-4">
                            <label for="unit" class="form-label">Satuan</label>
                            <select class="form-select" id="unit" name="unit">
                                <option value="pcs">Pcs</option>
                                <option value="unit">Unit</option>
                                <option value="pack">Pack</option>
                                <option value="botol">Botol</option>
                                <option value="dus">Dus</option>
                                <option value="kg">Kg</option>
                                <option value="liter">Liter</option>
                            </select>
                        </div>
                    </div>

                    <div class="mt-3">
                        <label for="description" class="form-label">Deskripsi</label>
                        <textarea class="form-control" id="description" name="description" rows="3" placeholder="Deskripsi produk (opsional)"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Produk</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
// Helper functions
function getStockStatus($product) {
    if ($product['type'] == 'service') return 'Aktif';
    if ($product['stock'] == 0) return 'Habis';
    if ($product['stock'] <= $product['min_stock']) return 'Rendah';
    return 'Tersedia';
}

function getStatusClass($status) {
    switch ($status) {
        case 'Habis': return 'out-of-stock';
        case 'Rendah': return 'low-stock';
        default: return '';
    }
}

function getProductIcon($type) {
    $icons = [
        'sparepart' => 'cog',
        'service' => 'concierge-bell',
        'food' => 'utensils',
        'beverage' => 'coffee'
    ];
    return $icons[$type] ?? 'box';
}

function getTypeColor($type) {
    $colors = [
        'sparepart' => 'primary',
        'service' => 'success',
        'food' => 'warning',
        'beverage' => 'info'
    ];
    return $colors[$type] ?? 'secondary';
}
?>

<style>
.out-of-stock {
    background-color: #fff5f5;
}
.low-stock {
    background-color: #fffbf0;
}
.product-icon {
    width: 40px;
    height: 40px;
    border-radius: 8px;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
}
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}
.stat-card {
    background: white;
    padding: 1.5rem;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    text-align: center;
    border-left: 4px solid;
}
.stat-card.primary { border-left-color: #4361ee; }
.stat-card.warning { border-left-color: #ffd60a; }
.stat-card.danger { border-left-color: #ef476f; }
.stat-card.success { border-left-color: #06d6a0; }
.stat-icon {
    font-size: 2rem;
    margin-bottom: 0.5rem;
}
.stat-value {
    font-size: 2rem;
    font-weight: bold;
    margin-bottom: 0.25rem;
}
.stat-label {
    color: #6c757d;
    font-size: 0.875rem;
}
</style>

<script>
// Toggle stock fields based on product type
function toggleStockFields() {
    const type = document.getElementById('type').value;
    const stockFields = document.getElementById('stockFields');
    
    if (type === 'service') {
        stockFields.style.display = 'none';
        document.getElementById('stock').value = 0;
        document.getElementById('min_stock').value = 0;
    } else {
        stockFields.style.display = 'flex';
    }
}

// Reset form
function resetForm() {
    document.getElementById('productForm').reset();
    document.getElementById('productId').value = '';
    document.getElementById('modalTitle').textContent = 'Tambah Produk Baru';
    document.getElementById('stockFields').style.display = 'flex';
}

// Form validation
function validateForm() {
    const name = document.getElementById('name').value.trim();
    const type = document.getElementById('type').value;
    const sellingPrice = document.getElementById('selling_price').value;
    
    if (!name) {
        alert('Nama produk harus diisi!');
        return false;
    }
    
    if (!type) {
        alert('Jenis produk harus dipilih!');
        return false;
    }
    
    if (!sellingPrice || parseFloat(sellingPrice) <= 0) {
        alert('Harga jual harus lebih dari 0!');
        return false;
    }
    
    return true;
}

// Edit product
function editProduct(id) {
    fetch(`../api/get_product.php?id=${id}`)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(product => {
            if (product.error) {
                throw new Error(product.error);
            }
            
            document.getElementById('productId').value = product.id;
            document.getElementById('barcode').value = product.barcode || '';
            document.getElementById('name').value = product.name;
            document.getElementById('type').value = product.type;
            document.getElementById('category_id').value = product.category_id || '';
            document.getElementById('purchase_price').value = product.purchase_price;
            document.getElementById('selling_price').value = product.selling_price;
            document.getElementById('stock').value = product.stock;
            document.getElementById('min_stock').value = product.min_stock;
            document.getElementById('unit').value = product.unit;
            document.getElementById('description').value = product.description || '';
            
            document.getElementById('modalTitle').textContent = 'Edit Produk';
            toggleStockFields();
            
            new bootstrap.Modal(document.getElementById('productModal')).show();
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Gagal memuat data produk: ' + error.message);
        });
}

// Confirm delete - PERBAIKAN UTAMA
function confirmDelete(id, name) {
    if (confirm(`Apakah Anda yakin ingin menghapus produk "${name}"?\n\nProduk yang sudah memiliki transaksi tidak dapat dihapus.`)) {
        // Show loading state
        const deleteBtn = event.target;
        const originalHTML = deleteBtn.innerHTML;
        deleteBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
        deleteBtn.disabled = true;
        
        // PERBAIKAN: Gunakan window.location.replace untuk mencegah masalah history
        window.location.replace(`pages/products.php?delete=${id}`);
    }
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', function() {
    toggleStockFields(); // Set initial state
    
    // Reset form when modal is hidden
    document.getElementById('productModal').addEventListener('hidden.bs.modal', resetForm);
    
    // Debug: Log untuk memeriksa apakah halaman products.php dimuat
    console.log('Products page loaded successfully');
});
</script>

<?php include '../includes/footer.php'; ?>

<?php ob_end_flush(); // Send output buffer and turn off buffering ?>