<?php
// pages/print_transaction.php
include '../config/database.php';

// Check if code parameter is set
if (!isset($_GET['code'])) {
    die("Kode transaksi tidak valid.");
}

$transaction_code = escape($_GET['code']);

// Get transaction data
$transaction_query = query("SELECT t.*, c.name as customer_name, c.phone as customer_phone, c.email as customer_email,
                           u.name as cashier_name 
                           FROM transactions t 
                           LEFT JOIN customers c ON t.customer_id = c.id 
                           LEFT JOIN users u ON t.user_id = u.id 
                           WHERE t.transaction_code = '$transaction_code'");
$transaction = $transaction_query->fetch_assoc();

if (!$transaction) {
    die("Transaksi tidak ditemukan.");
}

// Get transaction items
$items_query = query("SELECT ti.*, p.name as product_name, p.sku as product_sku, p.type as product_type 
                      FROM transaction_items ti 
                      LEFT JOIN products p ON ti.product_id = p.id 
                      WHERE ti.transaction_id = '{$transaction['id']}'");

// Hitung total amount dari items
$total_amount_from_items = 0;
$temp_items = query("SELECT SUM(subtotal) as total FROM transaction_items WHERE transaction_id = '{$transaction['id']}'");
if ($temp_items && $temp_row = $temp_items->fetch_assoc()) {
    $total_amount_from_items = $temp_row['total'];
}

// Store info (sesuaikan dengan data toko Anda)
$store_name = "BGKL PRO SHOP";
$store_address = "Jl. Contoh No. 123, Jakarta";
$store_phone = "0812-3456-7890";
$store_email = "info@bgklproshop.com";
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Struk - <?php echo $transaction_code; ?></title>
    <style>
        * { 
            margin: 0; 
            padding: 0; 
            box-sizing: border-box; 
            font-family: 'Courier New', monospace;
        }
        body { 
            font-size: 12px; 
            padding: 10px;
            width: 80mm;
            margin: 0 auto;
            background: white;
            color: black;
        }
        .receipt-header { 
            text-align: center; 
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px dashed #000;
        }
        .receipt-header h2 { 
            margin: 5px 0; 
            font-size: 16px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .receipt-info { 
            margin-bottom: 10px;
            font-size: 11px;
        }
        .receipt-info div { 
            margin: 2px 0;
            display: flex;
            justify-content: space-between;
        }
        .items-table { 
            width: 100%; 
            border-collapse: collapse;
            margin: 10px 0;
            font-size: 11px;
        }
        .items-table th {
            text-align: left;
            padding: 4px 0;
            border-bottom: 1px solid #000;
            font-weight: bold;
        }
        .items-table td { 
            padding: 3px 0;
            vertical-align: top;
            border-bottom: 1px dashed #ccc;
        }
        .text-right { 
            text-align: right; 
        }
        .text-center { 
            text-align: center; 
        }
        .text-left { 
            text-align: left; 
        }
        .total-section { 
            border-top: 1px solid #000;
            margin-top: 10px;
            padding-top: 8px;
            font-size: 12px;
        }
        .total-line {
            display: flex;
            justify-content: space-between;
            margin: 3px 0;
        }
        .total-line.grand {
            font-weight: bold;
            margin-top: 5px;
            padding-top: 5px;
            border-top: 1px dashed #000;
        }
        .footer { 
            margin-top: 15px;
            padding-top: 8px;
            border-top: 1px dashed #000;
            text-align: center;
            font-size: 10px;
        }
        .barcode {
            font-family: 'Libre Barcode 128', cursive;
            font-size: 24px;
            letter-spacing: 0;
            margin: 5px 0;
        }
        .store-info {
            font-size: 10px;
            margin-bottom: 5px;
        }
        @media print {
            body { 
                padding: 5px;
                width: 76mm;
            }
            .no-print { 
                display: none !important; 
            }
            .receipt-header h2 {
                font-size: 15px;
            }
        }
        .item-name {
            max-width: 45mm;
            word-wrap: break-word;
        }
    </style>
    <link href="https://fonts.googleapis.com/css2?family=Libre+Barcode+128&display=swap" rel="stylesheet">
</head>
<body>
    <div class="receipt-content">
        <!-- Store Header -->
        <div class="receipt-header">
            <div class="store-info">
                <h2><?php echo $store_name; ?></h2>
                <div><?php echo $store_address; ?></div>
                <div>Telp: <?php echo $store_phone; ?></div>
                <div><?php echo $store_email; ?></div>
            </div>
        </div>
        
        <!-- Transaction Info -->
        <div class="receipt-info">
            <div>
                <span><strong>No. Transaksi:</strong></span>
                <span><?php echo $transaction_code; ?></span>
            </div>
            <div>
                <span><strong>Tanggal:</strong></span>
                <span><?php echo date('d/m/Y', strtotime($transaction['created_at'])); ?></span>
            </div>
            <div>
                <span><strong>Waktu:</strong></span>
                <span><?php echo date('H:i:s', strtotime($transaction['created_at'])); ?></span>
            </div>
            <div>
                <span><strong>Pelanggan:</strong></span>
                <span><?php echo $transaction['customer_name'] ?: 'Walk-in Customer'; ?></span>
            </div>
            <div>
                <span><strong>Kasir:</strong></span>
                <span><?php echo $transaction['cashier_name']; ?></span>
            </div>
        </div>
        
        <!-- Items -->
        <table class="items-table">
            <thead>
                <tr>
                    <th class="text-left" style="width: 60%">ITEM</th>
                    <th class="text-center" style="width: 15%">QTY</th>
                    <th class="text-right" style="width: 25%">SUBTOTAL</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $no = 1;
                $total_amount = 0;
                while ($item = $items_query->fetch_assoc()):
                    $subtotal = $item['quantity'] * $item['product_price'];
                    $total_amount += $subtotal;
                ?>
                <tr>
                    <td class="text-left item-name">
                        <?php echo $item['product_name']; ?>
                        <br>
                        <small>@ Rp <?php echo number_format($item['product_price'], 0, ',', '.'); ?></small>
                    </td>
                    <td class="text-center"><?php echo $item['quantity']; ?></td>
                    <td class="text-right">Rp <?php echo number_format($subtotal, 0, ',', '.'); ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        
        <!-- Total Section -->
        <div class="total-section">
            <div class="total-line">
                <span>Subtotal:</span>
                <span>Rp <?php echo number_format($total_amount_from_items, 0, ',', '.'); ?></span>
            </div>
            <?php if ($transaction['discount_amount'] > 0): ?>
            <div class="total-line">
                <span>Diskon:</span>
                <span>- Rp <?php echo number_format($transaction['discount_amount'], 0, ',', '.'); ?></span>
            </div>
            <?php endif; ?>
            <div class="total-line grand">
                <span>TOTAL:</span>
                <span>Rp <?php echo number_format($transaction['final_amount'], 0, ',', '.'); ?></span>
            </div>
            <div class="total-line">
                <span>Bayar (<?php echo strtoupper($transaction['payment_method']); ?>):</span>
                <span>Rp <?php echo number_format($transaction['payment_amount'], 0, ',', '.'); ?></span>
            </div>
            <?php if ($transaction['payment_method'] == 'cash' && $transaction['change_amount'] > 0): ?>
            <div class="total-line" style="font-weight: bold;">
                <span>Kembali:</span>
                <span>Rp <?php echo number_format($transaction['change_amount'], 0, ',', '.'); ?></span>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <div class="barcode">*<?php echo $transaction_code; ?>*</div>
            <div style="margin: 8px 0; font-size: 11px;">
                <strong>*** TERIMA KASIH ***</strong>
            </div>
            <div>Barang yang sudah dibeli</div>
            <div>tidak dapat ditukar/dikembalikan</div>
        </div>
        
        <!-- Print Controls (visible only when not printing) -->
        <div class="no-print" style="margin-top: 20px; text-align: center;">
            <button onclick="window.print()" style="padding: 10px 20px; background: #4361ee; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 12px; margin-right: 10px;">
                <span style="margin-right: 5px;">🖨️</span> Cetak Struk
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 12px;">
                <span style="margin-right: 5px;">✖️</span> Tutup
            </button>
        </div>
    </div>

    <script>
        // Auto print when the page loads
        window.onload = function() {
            // Small delay to ensure everything is loaded
            setTimeout(function() {
                window.print();
            }, 500);
        };

        // Close window after print (optional)
        window.onafterprint = function() {
            // You can choose to auto-close or leave it open
            // setTimeout(function() {
            //     window.close();
            // }, 1000);
        };
    </script>
</body>
</html>