<?php
include 'config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = escape($_POST['username']);
    $password = $_POST['password']; // Kita akan verify password
    
    $sql = "SELECT * FROM users WHERE username = '$username' AND is_active = 1";
    $result = query($sql);
    
    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        
        // NOTE: Untuk testing, password = '123456'
        // Di production, gunakan password_hash() dan password_verify()
        if ($password == '123456' || password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['name'] = $user['name'];
            $_SESSION['role'] = $user['role'];
            
            // Update last login
            query("UPDATE users SET last_login = NOW() WHERE id = {$user['id']}");
            
            header("Location: index.php");
            exit();
        } else {
            $error = "Password salah!";
        }
    } else {
        $error = "Username tidak ditemukan!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - POS System</title>
    <base href="<?php echo BASE_URL; ?>/">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
        }
        .login-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-4">
                <div class="login-card p-4">
                    <div class="text-center mb-4">
                        <h3>POS System Login</h3>
                        <p class="text-muted">Silakan masuk ke akun Anda</p>
                    </div>
                    
                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger"><?php echo $error; ?></div>
                    <?php endif; ?>
                    
                    <form method="POST">
                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" class="form-control" id="username" name="username" required 
                                   value="<?php echo isset($_POST['username']) ? $_POST['username'] : ''; ?>">
                        </div>
                        <div class="mb-3">
                            <label for="password" class="form-label">Password</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Login</button>
                    </form>
                    
                    <div class="mt-3 text-center">
                        <small class="text-muted">
                            <strong>Demo Accounts:</strong><br>
                            admin / 123456 (Full Access)<br>
                            kasir1 / 123456 (Kasir Only)<br>
                            teknisi1 / 123456 (Teknisi Only)
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>