<?php
// info.php - Hapus file ini setelah testing selesai!
echo "<h2>PHP Info & Database Test</h2>";

// Test koneksi database
$host = "localhost";
$username = "username_database_anda";
$password = "password_database_anda"; 
$database = "nama_database_anda";

echo "<h3>Database Connection Test:</h3>";
$conn = new mysqli($host, $username, $password, $database);

if ($conn->connect_error) {
    echo "<div style='color: red;'>❌ Database Connection FAILED: " . $conn->connect_error . "</div>";
} else {
    echo "<div style='color: green;'>✅ Database Connection SUCCESS!</div>";
    
    // Test query
    $result = $conn->query("SHOW TABLES");
    echo "<div>Tables found: " . $result->num_rows . "</div>";
    
    if ($result->num_rows > 0) {
        echo "<ul>";
        while ($row = $result->fetch_array()) {
            echo "<li>" . $row[0] . "</li>";
        }
        echo "</ul>";
    }
}

// Test PHP configuration
echo "<h3>PHP Configuration:</h3>";
echo "PHP Version: " . phpversion() . "<br>";
echo "Session Support: " . (function_exists('session_start') ? 'Enabled' : 'Disabled') . "<br>";

// Test file permissions
echo "<h3>File Permissions:</h3>";
$files_to_check = ['.htaccess', 'config/database.php', 'login.php'];
foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        echo "✅ $file exists<br>";
    } else {
        echo "❌ $file missing<br>";
    }
}

$conn->close();
?>