<?php
// index.php
include 'config/database.php';
include 'includes/header.php';

// Get stats
$today = date('Y-m-d');
$today_transactions = query("SELECT COUNT(*) as total FROM transactions WHERE DATE(created_at) = '$today'")->fetch_assoc()['total'];
$today_income = query("SELECT COALESCE(SUM(final_amount), 0) as total FROM transactions WHERE DATE(created_at) = '$today'")->fetch_assoc()['total'];
$low_stock = query("SELECT COUNT(*) as total FROM products WHERE stock <= min_stock AND type != 'service'")->fetch_assoc()['total'];
$total_products = query("SELECT COUNT(*) as total FROM products WHERE is_active = 1")->fetch_assoc()['total'];
?>

<!-- Stats Grid -->
<div class="stats-grid">
    <div class="stat-card primary">
        <div class="stat-icon">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="stat-value"><?php echo $today_transactions; ?></div>
        <div class="stat-label">Transaksi Hari Ini</div>
    </div>
    
    <div class="stat-card success">
        <div class="stat-icon">
            <i class="fas fa-money-bill-wave"></i>
        </div>
        <div class="stat-value">Rp <?php echo number_format($today_income, 0, ',', '.'); ?></div>
        <div class="stat-label">Pendapatan Hari Ini</div>
    </div>
    
    <div class="stat-card warning">
        <div class="stat-icon">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="stat-value"><?php echo $low_stock; ?></div>
        <div class="stat-label">Produk Stok Rendah</div>
    </div>
    
    <div class="stat-card danger">
        <div class="stat-icon">
            <i class="fas fa-boxes"></i>
        </div>
        <div class="stat-value"><?php echo $total_products; ?></div>
        <div class="stat-label">Total Produk</div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-bolt me-2"></i>Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-3 col-6">
                        <a href="pages/transactions.php" class="btn btn-primary w-100 h-100 py-3">
                            <i class="fas fa-cash-register fa-2x mb-2"></i><br>
                            Transaksi Baru
                        </a>
                    </div>
                    <div class="col-md-3 col-6">
                        <a href="pages/products.php" class="btn btn-success w-100 h-100 py-3">
                            <i class="fas fa-boxes fa-2x mb-2"></i><br>
                            Kelola Produk
                        </a>
                    </div>
                    <div class="col-md-3 col-6">
                        <a href="pages/customers.php" class="btn btn-info w-100 h-100 py-3">
                            <i class="fas fa-users fa-2x mb-2"></i><br>
                            Data Pelanggan
                        </a>
                    </div>
                    <div class="col-md-3 col-6">
                        <a href="pages/reports.php" class="btn btn-warning w-100 h-100 py-3">
                            <i class="fas fa-chart-bar fa-2x mb-2"></i><br>
                            Lihat Laporan
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Transactions -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-history me-2"></i>Transaksi Terbaru</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Kode</th>
                                <th>Tanggal</th>
                                <th>Customer</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th width="120">Aksi</th> <!-- Tambah kolom aksi -->
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $recent_transactions = query("SELECT t.*, c.name as customer_name 
                                                         FROM transactions t 
                                                         LEFT JOIN customers c ON t.customer_id = c.id 
                                                         ORDER BY t.created_at DESC 
                                                         LIMIT 5");
                            while ($transaction = $recent_transactions->fetch_assoc()):
                            ?>
                            <tr>
                                <td><strong><?php echo $transaction['transaction_code']; ?></strong></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($transaction['created_at'])); ?></td>
                                <td><?php echo $transaction['customer_name'] ?: 'Walk-in'; ?></td>
                                <td><strong>Rp <?php echo number_format($transaction['final_amount'], 0, ',', '.'); ?></strong></td>
                                <td>
                                    <span class="badge bg-<?php echo $transaction['transaction_status'] == 'completed' ? 'success' : 'warning'; ?>">
                                        <?php echo ucfirst($transaction['transaction_status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <!-- Tombol View -->
                                        <a href="pages/transaction_detail.php?code=<?php echo $transaction['transaction_code']; ?>" 
                                           class="btn btn-info" 
                                           title="View Detail">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <!-- Tombol Print -->
                                        <a href="pages/print_transaction.php?code=<?php echo $transaction['transaction_code']; ?>" 
                                           class="btn btn-secondary" 
                                           title="Print"
                                           target="_blank">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; ?>