<?php
// includes/header.php
// Start session dan check login di AWAL file
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// Redirect jika belum login - lakukan SEBELUM output apapun
if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}
// Set variabel setelah redirect
$current_page = basename($_SERVER['PHP_SELF']);
$page_title = [
    'index.php' => 'Dashboard',
    'transactions.php' => 'Transaksi',
    'products.php' => 'Produk',
    'customers.php' => 'Pelanggan',
    'reports.php' => 'Laporan',
    'users.php' => 'User Management'
][$current_page] ?? 'POS System';

?>

<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - POS System</title>
    
    <!-- Base URL tanpa trailing slash -->
    <base href="<?php echo rtrim(BASE_URL, '/'); ?>/">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link href="<?php echo ASSETS_URL; ?>/css/style.css" rel="stylesheet">
    
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
<body>
    <div class="app-container">
        <!-- Mobile Overlay -->
        <div class="mobile-overlay"></div>
        
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h4><i class="fas fa-cash-register"></i> POS System</h4>
                <p>Welcome, <?php echo htmlspecialchars($_SESSION['name']); ?></p>
            </div>
            
            <nav class="sidebar-nav">
                <a href="index.php" class="<?php echo $current_page == 'index.php' ? 'active' : ''; ?>">
                    <i class="fas fa-home"></i> Dashboard
                </a>
                <a href="pages/transactions.php" class="<?php echo $current_page == 'transactions.php' ? 'active' : ''; ?>">
                    <i class="fas fa-shopping-cart"></i> Transaksi
                </a>
                <a href="pages/products.php" class="<?php echo $current_page == 'products.php' ? 'active' : ''; ?>">
                    <i class="fas fa-box"></i> Produk
                </a>
                <a href="pages/customers.php" class="<?php echo $current_page == 'customers.php' ? 'active' : ''; ?>">
                    <i class="fas fa-users"></i> Pelanggan
                </a>
                <a href="pages/reports.php" class="<?php echo $current_page == 'reports.php' ? 'active' : ''; ?>">
                    <i class="fas fa-chart-bar"></i> Laporan
                </a>
                <?php if ($_SESSION['role'] == 'admin'): ?>
                <a href="pages/users.php" class="<?php echo $current_page == 'users.php' ? 'active' : ''; ?>">
                    <i class="fas fa-user-cog"></i> User Management
                </a>
                <?php endif; ?>
                <a href="logout.php">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </nav>
        </div>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Top Header -->
            <div class="top-header">
                <div class="d-flex align-items-center">
                    <button class="menu-toggle d-md-none">
                        <i class="fas fa-bars"></i>
                    </button>
                    <div class="header-title">
                        <h2><i class="fas fa-<?php 
                            echo [
                                'index.php' => 'home',
                                'transactions.php' => 'cash-register',
                                'products.php' => 'boxes',
                                'customers.php' => 'users',
                                'reports.php' => 'chart-bar',
                                'users.php' => 'user-cog'
                            ][$current_page] ?? 'cog'; 
                        ?> me-2"></i><?php echo $page_title; ?></h2>
                    </div>
                </div>
                
                <div class="header-actions">
                    <div class="user-info">
                        <div class="user-avatar">
                            <?php echo strtoupper(substr($_SESSION['name'], 0, 1)); ?>
                        </div>
                        <div class="d-none d-md-block">
                            <div class="fw-bold"><?php echo htmlspecialchars($_SESSION['name']); ?></div>
                            <small class="text-muted"><?php echo ucfirst($_SESSION['role']); ?></small>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Content Area -->
            <div class="content-area">