<?php
// api/save_customer.php
include '../config/database.php';

// Start session dan check login
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = escape($_POST['name'] ?? '');
    $phone = escape($_POST['phone'] ?? '');
    $email = escape($_POST['email'] ?? '');
    $address = escape($_POST['address'] ?? '');
    $birth_date = escape($_POST['birth_date'] ?? '');
    $customer_type = escape($_POST['customer_type'] ?? 'regular');
    $notes = escape($_POST['notes'] ?? '');

    // Validasi input
    if (empty($name) || empty($phone)) {
        echo json_encode(['success' => false, 'message' => 'Nama dan nomor telepon harus diisi!']);
        exit;
    }

    // Check jika nomor telepon sudah ada
    $check_sql = "SELECT id FROM customers WHERE phone = '$phone'";
    $check_result = query($check_sql);
    if ($check_result->num_rows > 0) {
        echo json_encode(['success' => false, 'message' => 'Nomor telepon sudah terdaftar!']);
        exit;
    }

    // Generate customer code
    $customer_code = "CUST" . date('YmdHis');

    // Convert empty birth_date to NULL
    $birth_date_sql = $birth_date ? "'$birth_date'" : "NULL";

    // Insert customer
    $sql = "INSERT INTO customers (customer_code, name, email, phone, address, customer_type, birth_date, notes) 
            VALUES ('$customer_code', '$name', '$email', '$phone', '$address', '$customer_type', $birth_date_sql, '$notes')";

    if (query($sql)) {
        $new_customer_id = lastInsertId();
        
        echo json_encode([
            'success' => true, 
            'message' => 'Pelanggan berhasil ditambahkan!',
            'customer' => [
                'id' => $new_customer_id,
                'name' => $name,
                'phone' => $phone,
                'email' => $email
            ]
        ]);
    } else {
        $error = "Gagal menambahkan pelanggan: " . mysqli_error($connection);
        echo json_encode(['success' => false, 'message' => $error]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>