<?php
declare(strict_types=1);

namespace Transactions\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;


class PartSalesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('part_sales');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp');


        $this->hasMany('PartSalesDetails', [
            'className'=>'Transactions.PartSalesDetails',
            'foreignKey' => 'trx_id'
        ]);



    }
   
}
