<?php
declare(strict_types=1);

namespace Transactions\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;


class InvoicesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('workshops');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp');


        $this->hasMany('InvoiceParts', [
            'className'=>'Transactions.InvoiceParts',
            'foreignKey' => 'workshop_id'
        ]);
        $this->hasMany('InvoiceJasas', [
            'className'=>'Transactions.InvoiceJasas',
            'foreignKey' => 'workshop_id'
        ]);

    }
    
     public function getNewCustomersPerDay($startDate, $endDate)
    {
        $query = $this->find();
        $query->select([
            'date' => $query->func()->date_format(['trans_date' => 'identifier', "'%Y-%m-%d'" => 'literal']),
            'new_customers' => $query->func()->count('DISTINCT nopol')
        ])
        ->where(["trans_date BETWEEN :start AND :end"])
        ->andWhere(function ($exp, $q) use ($startDate) {
            return $exp->notExists(
                $q->newExpr()
                    ->add('SELECT 1 FROM workshops t2 WHERE t2.nopol = workshops.nopol AND t2.trans_date < :start')
            );
        })
        ->bind(':start', $startDate, 'date')
        ->bind(':end', $endDate, 'date')
        ->group(['date']);
        return $query;
    }
}