<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;

class PartSalesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Pengeluaran Part';
        $data['titleMenu'] = 'List Data Pengeluaran Part';

        $this->paginate = [
            'limit' => 20,
            'order' => [
                'created' => 'desc',
            ],
        ];

        $query = $this->PartSales->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
            'OR' => [
                'trx_code LIKE' => '%' . $search . '%',
                'trx_desc LIKE' => '%' . $search . '%',
                'trx_date' => $search,
            ]
        ]);
        }

        $partsales = $this->paginate($query);

        $this->set(compact('data', 'partsales'));
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $data['titlePage'] = 'Pengeluaran Part';
        $data['titleMenu'] = 'List Data Pengeluaran Part';
        $partsales = $this->PartSales->get($id, contain: ['PartSalesDetails']);
        $this->set(compact('data','partsales'));
    }
    public function prints($id = null)
    {

        $this->viewBuilder()->setLayout('print');
        $data['titlePage'] = 'Pengeluaran Part';
        $data['titleMenu'] = 'View Data Pengeluaran Part';

        $partsales = $this->PartSales->get($id, contain: ['PartSalesDetails']);
        $this->set(compact('data','partsales'));
    }
    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Pengeluaran Part';
        $data['titleMenu'] = 'Add Data Pengeluaran Part';

        $this->loadComponent('General');
        $setStatus = 1;
        $partsales = $this->PartSales->newEmptyEntity();
        if($this->request->is('post')){
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $partsales = $this->PartSales->patchEntity($partsales, $this->request->getData());

            $partsales->trx_code=$this->General->__sinchronizeID('PS',date('ym'),5,array('val_id','val_char', 'val_value'));
            $partsales->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $partsales->modi_by = $this->getRequest()->getSession()->read('Auth.id');

            


            
            $partsales->branch_code= $this->getRequest()->getSession()->read('Auth.branch_code');;
            $partsales->branch_id= $this->getRequest()->getSession()->read('Auth.branch_id');

            $total=0;
  			$qty=0;
  			$j=0;
  			
            // dd($partsales->part_sales_details);
            if($partsales->part_sales_details){
              $transLog = [];   
              foreach ($partsales->part_sales_details as $i => $v) {
                if($v->partnumber !=''){
                $partsales->part_sales_details[$i]->trx_code = $partsales->trx_code;
                $partsales->part_sales_details[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                $partsales->part_sales_details[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                $partsales->part_sales_details[$i]->created = date("Y-m-d h:i:s");
                $partsales->part_sales_details[$i]->modified = date("Y-m-d h:i:s");
                $partsales->part_sales_details[$i]->price = $this->General->__sinchronizecurrency($partsales->part_sales_details[$i]->price);

                $partsales->part_sales_details[$i]->disc = $this->General->__sinchronizecurrency($partsales->part_sales_details[$i]->disc);
                $partsales->part_sales_details[$i]->total = $this->General->__sinchronizecurrency($partsales->part_sales_details[$i]->total);

                $partsales->part_sales_details[$i]->branch_code = $partsales->branch_code;
                $partsales->part_sales_details[$i]->branch_id = $partsales->branch_id;

                $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['kode_gudang'=>$v->warehouse_code])->select(['id'])->first();
                $partsales->part_sales_details[$i]->warehouse_id = $getwarehouseID->id;

                $getrakID = $this->fetchTable('Masters.Raks')->find()->where(['rak_code'=>$v->rak_code])->select(['id'])->first();
                $partsales->part_sales_details[$i]->rak_id = $getrakID->id;

                $getPartsname = $this->fetchTable('Masters.Parts')->find()->where(['partnumber'=>$v->partnumber])->select(['deskripsi'])->first();
                $partsales->part_sales_details[$i]->partdesc = $getPartsname->deskripsi;

                $transLog[$i]['trx_code'] = $partsales->trx_code;
                $transLog[$i]['trx_date'] = date('Y-m-d H:i:s');
                $transLog[$i]['part_no'] =  $v->partnumber;
                $transLog[$i]['part_name'] = $getPartsname->deskripsi;
                $transLog[$i]['in_out'] = 'O';
                $transLog[$i]['qty'] = $v->qty;
                $transLog[$i]['warehouse_code'] = $v->warehouse_code;
                $transLog[$i]['warehouse_id'] = $getwarehouseID->id;
                $transLog[$i]['rak_code'] = $v->rak_code;
                $transLog[$i]['rak_id'] = $getrakID->id;
                $transLog[$i]['branch_code'] = $partsales->branch_code;
                $transLog[$i]['branch_id'] = $partsales->branch_id;


              }else{
                unset($partsales->part_sales_details[$i]);
              }
              }
            }

            if($setStatus){

                if ($this->PartSales->save($partsales,[ 'associated' => ['PartSalesDetails']])) {
                    $setStatus = 1;
                    $message = 'The data has been saved.';
                    // dd($transLog);
                    if($transLog){
                        $logpartTable = $this->fetchTable('Transactions.LogParts');
                        $logs = $logpartTable->newEntities($transLog);
                        $resulLogs = $logpartTable->saveMany($logs);
                        if($resulLogs){
                         //update stok
                            $parttable = $this->fetchTable('Transactions.StockParts');
                            foreach ($transLog as $i => $v) {
                              $getStocks = $parttable->find()->where(['partnumber'=>$v['part_no'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                              //dd($v);
                              $getStocks->qty = $getStocks->qty - $v['qty']; 
                              if(!$parttable->save($getStocks)){
                                    $setStatus = 0;
                                    $message = 'Fail update stocks. Please, try again.';
                                    break;
                              }else{
                                    $setStatus = 1;
                                    $message = 'The data has been saved.';
                              }
                            }
                        }else{
                            $setStatus = 0;
                            $message = 'The log parts could not be saved. Please, try again.';
                        }
                    }


                }else{
                    $setStatus = 0;
                    $message = 'The data could not be saved. Please, try again.';
                }
            }else{
                $setStatus = 0;
                if(isset($message)) $message=$message;
                else $message = 'Saldo stock tidak memenuhi.';
            }

            if($setStatus){
                $connection->commit();
                $message = 'The data has been saved.';
                $this->Flash->set(__($message));
                return $this->redirect(['action' => 'index']);
            }else {
                $this->Flash->set(__($message));
                $connection->rollback();
            }

        }

        
       
        $this->set(compact('data','partsales'));
    }

    

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $data = $this->Invoices->get($id);
        if ($this->Invoices->delete($data)) {
            $this->Flash->success(__('The user has been deleted.'));
        } else {
            $this->Flash->error(__('The user could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

   
    function getSparepart($partnumber){
        $warehouseTable = $this->fetchTable('Masters.Warehouses');
        $getWarehouse = $warehouseTable->find()->where(['branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code')])->first();
        $parttable = $this->fetchTable('Transactions.StockParts');
        $getParts = $parttable->find()
                    ->where([
                            'partnumber'=>$partnumber,
                            'branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code'),
                            'warehouse_code'=>$getWarehouse->kode_gudang
                            ])
                        ->first();
        echo json_encode($getParts);
        exit;
    }
    
    function getpartdetail(){
        $this->autoRender = false;
        $keyword = $this->request->getQuery('term');

        $parttable = $this->fetchTable('Transactions.StockParts');
        $suggestions = $parttable
            ->find('list',
            keyField : 'partnumber',
            valueField : 'partnumber'
            )->where(['partnumber LIKE' => '%' . $keyword . '%','branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code')])
            ->toArray();
        foreach($suggestions as $i=>$v){
            $result[$i] = ['id'=>$i,'label'=>$v,'value'=>$v];
        }
        echo json_encode($result);
        exit;
    }

    function batal($id){
        $this->request->allowMethod(['post', 'delete']);
        $connection = ConnectionManager::get('default');
        $connection->begin();
        $data = $this->PartSales->get($id,
            contain : ['PartSalesDetails']
        );
        if($data->status == 1){
            $this->Flash->success(__('Kode Pengeluaran Part ini  '.$data->trx_code.' sudah dibatalkan sebelumnya.'));
            return $this->redirect(['action' => 'index']);
        }
        $data->status = 1;
        $update = $this->PartSales->save($data);
        if ($update) {
            //add log trans
            $logpartTable = $this->fetchTable('Transactions.LogParts');
            foreach($data->part_sales_details as $i=>$v){
                
                $entLog = $logpartTable->newEmptyEntity();

                $entLog->trx_code = $data->trx_code;
                $entLog->trx_date = $data->trans_date;
                $entLog->part_no = $v->partnumber;
                $entLog->part_name = $v->partdesc;
                $entLog->in_out = 'I';
                $entLog->qty = $v->qty;
                $entLog->warehouse_code = $v->warehouse_code;
                $entLog->warehouse_id = $v->warehouse_id;
                $entLog->rak_code = $v->rak_code;
                $entLog->rak_id = $v->rak_id;
                $entLog->branch_id = $v->branch_id;
                $entLog->branch_code = $v->branch_code;
                $resulLogs = $logpartTable->save($entLog);
                if(!$logpartTable->save($entLog)){
                   
                    $setStatus = 0;
                    $message = 'Fail add log partnumber. Please, try again.';
                }else{
                    
                      //update mst stok
                      $parttable = $this->fetchTable('Transactions.StockParts');
                      $getStocks = $parttable->find()->where(['partnumber'=>$v['partnumber'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                              //dd($v);
                      $getStocks->qty = $getStocks->qty + $v['qty']; 
                      if(!$parttable->save($getStocks)){
                            $setStatus = 0;
                            $message = 'Fail update stocks. Please, try again.';
                            break;
                      }else{
                            $setStatus = 1;
                            $message = 'The data has been saved.';
                      }
                }


            }
          
            $connection->commit();
            $this->Flash->success(__('Pengeluaran Part sudah dibatalkan.'));
        } else {
            $connection->rollback();
            $this->Flash->error(__('Pengeluaran Part  gagal dibatalkan. Silakan mencoba kembali.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
