<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

$fileName = 'report_top_sales.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set company name and date
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', 'Tanggal : ' . $periode);
$sheet->setCellValue('A4', 'Report Top Sales');
$sheet->getStyle('A1:A4')->getFont()->setBold(true);
$sheet->mergeCells('A1:E1');
$sheet->mergeCells('A2:E2');
$sheet->mergeCells('A4:E4');

$row = 6;

// Table headers
$sheet->setCellValue('A'.$row, 'Part Number');
$sheet->setCellValue('B'.$row, 'Part Description');
$sheet->setCellValue('C'.$row, 'Total Qty');
$sheet->setCellValue('D'.$row, 'Total Sales');

$sheet->getStyle('A'.$row.':D'.$row)->getFont()->setBold(true);
$sheet->getStyle('A'.$row.':D'.$row)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
$sheet->getStyle('A'.$row.':D'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
$sheet->getStyle('A'.$row.':D'.$row)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFD3D3D3');

$row++;

foreach ($result as $i => $v) {
    $sheet->setCellValue('A'.$row, $v['partnumber']);
    $sheet->setCellValue('B'.$row, $v['partdesc']);
    $sheet->setCellValue('C'.$row, $v['total_qty']);
    $sheet->setCellValue('D'.$row, $v['total_sales']);

    $sheet->getStyle('C'.$row.':D'.$row)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
    $sheet->getStyle('A'.$row.':D'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

    $row++;
}

// Apply autosize to all columns
foreach (range('A', 'D') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

// Output to browser
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName) .'"');
$writer->save('php://output');
exit;
?>
