<?php 
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

$fileName = 'report_profit.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set company name and address
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', $company['address']);
$sheet->setCellValue('A4', 'Report Profit');
$sheet->setCellValue('A5', 'Tanggal');
$sheet->setCellValue('B5', $periode);

// Apply bold and merge cells
$sheet->getStyle('A1:A2')->getFont()->setBold(true);
$sheet->getStyle('A4:A5')->getFont()->setBold(true);
$sheet->mergeCells('A1:C1');
$sheet->mergeCells('A2:E2');
$sheet->mergeCells('A4:C4');

$row = 7;

// Calculate total and expenses
$total = isset($data['total_pendapatan']) ? $data['total_pendapatan'] : 0;
$tPengeluaran = (isset($data['pengeluaran'][0]['total']) ? $data['pengeluaran'][0]['total'] : 0) + 
                (isset($data['pengeluaran_kas'][0]['total']) ? $data['pengeluaran_kas'][0]['total'] : 0) + 
                (isset($data['pengeluaran_kas_other'][0]['total']) ? $data['pengeluaran_kas_other'][0]['total'] : 0);
$ttotal = $total - $tPengeluaran;

// Pendapatan section
$sheet->setCellValue('A'.$row, 'Pendapatan');
$sheet->getStyle('A'.$row)->getFont()->setBold(true);
$row++;
$sheet->setCellValue('B'.$row, 'Part');
$sheet->setCellValue('C'.$row, isset($data['pendapatan'][0]['part']) ? $data['pendapatan'][0]['part'] : 0);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;
$sheet->setCellValue('B'.$row, 'Jasa');
$sheet->setCellValue('C'.$row, isset($data['pendapatan'][0]['jasa']) ? $data['pendapatan'][0]['jasa'] : 0);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;
$sheet->setCellValue('B'.$row, 'Total');
$sheet->setCellValue('C'.$row, $total);
$sheet->getStyle('B'.$row.':C'.$row)->getFont()->setBold(true);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;
$sheet->setCellValue('B'.$row, 'Diskon');
$sheet->setCellValue('C'.$row, isset($data['total_diskon']) ? $data['total_diskon'] : 0);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;
$sheet->setCellValue('B'.$row, 'Pendapatan Net');
$sheet->setCellValue('C'.$row, isset($data['pendapatan_net']) ? $data['pendapatan_net'] : 0);
$sheet->getStyle('B'.$row.':C'.$row)->getFont()->setBold(true);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;

// Pengeluaran section
$sheet->setCellValue('A'.$row, 'Pengeluaran');
$sheet->getStyle('A'.$row)->getFont()->setBold(true);
$row++;
$sheet->setCellValue('B'.$row, 'Pembelian Part');
$sheet->setCellValue('C'.$row, isset($data['pengeluaran'][0]['total']) ? $data['pengeluaran'][0]['total'] : 0);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;
$sheet->setCellValue('B'.$row, 'Pengeluaran Kas Bengkel');
$sheet->setCellValue('C'.$row, isset($data['pengeluaran_kas'][0]['total']) ? $data['pengeluaran_kas'][0]['total'] : 0);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;
$sheet->setCellValue('B'.$row, 'Lain - Lain');
$sheet->setCellValue('C'.$row, isset($data['pengeluaran_kas_other'][0]['total']) ? $data['pengeluaran_kas_other'][0]['total'] : 0);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row++;
$sheet->setCellValue('B'.$row, 'Total');
$sheet->setCellValue('C'.$row, $tPengeluaran);
$sheet->getStyle('B'.$row.':C'.$row)->getFont()->setBold(true);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');
$row += 2;

// Grand Total section
$sheet->setCellValue('B'.$row, 'Grand Total');
$sheet->setCellValue('C'.$row, $ttotal);
$sheet->getStyle('B'.$row.':C'.$row)->getFont()->setBold(true);
$sheet->getStyle('C'.$row)->getNumberFormat()->setFormatCode('"Rp"#,##0.00');

// Apply autosize to all columns
foreach (range('A', 'C') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

// Output to browser
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName) .'"');
$writer->save('php://output');
exit;