<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry; // Import TableRegistry

class ReportPriceHistoryController extends AppController
{
    public function index()
    {
        $data['titlePage'] = 'Report History Harga Part';
        $data['titleMenu'] = 'Report History Harga Part';

        $conn = ConnectionManager::get('default');

         if ($this->request->is('post')) {
            $start = $this->request->getData('start');
            $end = $this->request->getData('end');
            $partnumber = $this->request->getData('partnumber');
            $filterType = $this->request->getData('filter_type'); // Get selected filter type

            try {
                $query = "
                    SELECT p.*, m.deskripsi
                    FROM part_price_history p
                    LEFT JOIN mst_parts m ON p.partnumber = m.partnumber
                    WHERE 1=1"; // Start with a condition that always evaluates to true

                $bindParams = [];

                if ($filterType === 'date' || $filterType === 'both') {
                    $query .= " AND p.created >= :start AND p.created <= :end";
                    $bindParams['start'] = $start;
                    $bindParams['end'] = $end;
                }

                if ($filterType === 'partnumber' || $filterType === 'both') {
                    if ($partnumber) {
                        $query .= " AND p.partnumber LIKE :partnumber";
                        $bindParams['partnumber'] = '%' . $partnumber . '%';
                    }
                }

                $query .= " ORDER BY p.created DESC";

                $result = $conn->execute($query, $bindParams)->fetchAll('assoc');

            } catch (\Exception $e) {
                $this->Flash->error(__('Terjadi kesalahan saat mengambil data: '). $e->getMessage());
                return $this->redirect(['action' => 'index']);
            }

            if (empty($result)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            $this->set(compact('data', 'result', 'start', 'end', 'partnumber')); // Mengirim partnumber ke view
            $this->render('index');
        }

        $this->set(compact('data')); // Inisialisasi form pencarian
    }

    public function autocompletePart()
    {
        $this->autoRender = false;
        $term = $this->request->getQuery('term');

         // Gunakan TableRegistry untuk load model Parts
        $partsTable = TableRegistry::get('Masters.Parts'); // Ganti 'Masters.Parts' dengan nama table alias anda

        $parts = $partsTable->find('all', [
            'conditions' => ['partnumber LIKE' => '%' . $term . '%'],
            'limit' => 10
        ])->toArray();

        $data = array_map(function ($part) {
            return [
                'label' => $part['partnumber'],
                'value' => $part['partnumber']
            ];
        }, $parts);

        echo json_encode($data);
        exit;
    }
}