<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;

class ReportPenjualanPartFrontdesksController extends AppController
{
    public function index()
    {
        $conn = ConnectionManager::get('default');
        $data['titlePage'] = 'Report Penjualan Part Frontdesk';
        $data['titleMenu'] = 'Report Penjualan Part Frontdesk';

        if ($this->request->is('post')) {
            $start = $this->request->getData('start');
            $end = $this->request->getData('end');

            // Validasi input tanggal
            if (!$start || !$end || !strtotime($start) || !strtotime($end)) {
                $this->Flash->error(__('Tanggal tidak valid.'));
                return $this->redirect(['action' => 'index']);
            }

            try {
                $result = $conn->execute("
                    SELECT a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, 
                           (c.price * sub.total_qty * (1 - (c.diskon/100))) AS total_sales, c.total_harga, c.price, c.diskon, c.created
                    FROM workshops a 
                    LEFT JOIN (
                        SELECT workshop_id, partnumber, SUM(qty) as total_qty
                        FROM workshops_dtlparts
                        GROUP BY workshop_id, partnumber
                    ) sub ON a.id = sub.workshop_id
                    LEFT JOIN workshops_dtlparts c ON a.id = c.workshop_id AND sub.partnumber = c.partnumber
                    LEFT JOIN mst_employes e ON a.mekanik = e.employee_code
                    WHERE a.trans_date >= :start AND a.trans_date <= :end 
                        AND a.status != '1' 
                        AND c.status != '1'
                    GROUP BY a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, c.total_harga, c.price, c.diskon, c.created
                    ORDER BY a.trans_date ASC", ['start' => $start, 'end' => $end])->fetchAll('assoc');

            } catch (\Exception $e) {
                $this->Flash->error(__('Terjadi kesalahan saat mengambil data: ' . $e->getMessage()));
                return $this->redirect(['action' => 'index']);
            }

            if (empty($result)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            $company = [
                'name' => 'AHASS RAJAWALI PUTERA',
                'address' => 'Alamat Perusahaan'
            ];

            switch ($this->request->getData('type')) {
                case 'html':
                    $file = 'html';
                    break;
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $periode = date("d F Y", strtotime($start)) . ' - ' . date("d F Y", strtotime($end));
            $this->set(compact('data', 'periode', 'company', 'result'));
            $this->render($file);
        }

        $this->set(compact('data'));
    }
}