<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPendapatanMekaniksController extends AppController
{

    public $PhpExcel = null;

    public function index()
    {

     $conn = ConnectionManager::get('default');
     $data['titlePage'] = 'Report Pendapatan Mekanik';
     $data['titleMenu'] = 'Report Pendapatan Mekanik';
      if ($this->request->is('post')) { 
         	
		  $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
		  $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
		 
		 $start = $this->request->getData('start');
		 $end = $this->request->getData('end');
		 
		 $result = $conn->execute("
    SELECT Z.mekanik, Z.nama_mekanik, SUM(Z.GO) GO, SUM(Z.CS) CS, SUM(Z.KPB1) KPB1, SUM(Z.KPB2) KPB2, SUM(Z.KPB3) KPB3, SUM(Z.KPB4) KPB4, 
           SUM(Z.SL) SL, SUM(Z.SR) SR, SUM(Z.TOTAL_JASA) TOTAL_JASA, SUM(Z.TOTAL_PART) TOTAL_PART, 
           (SUM(Z.TOTAL_JASA) + SUM(Z.TOTAL_PART)) TOTAL 
    FROM (
        SELECT a.mekanik, e.nama_mekanik, 
               SUM(CASE WHEN c.kode_jasa='GO' THEN c.total_harga ELSE 0 END) GO, 
               SUM(CASE WHEN c.kode_jasa='CS' THEN c.total_harga ELSE 0 END) CS, 
               SUM(CASE WHEN c.kode_jasa LIKE 'KPB1%' THEN c.total_harga ELSE 0 END) KPB1, 
               SUM(CASE WHEN c.kode_jasa LIKE 'KPB2%' THEN c.total_harga ELSE 0 END) KPB2, 
               SUM(CASE WHEN c.kode_jasa LIKE 'KPB3%' THEN c.total_harga ELSE 0 END) KPB3, 
               SUM(CASE WHEN c.kode_jasa LIKE 'KPB4%' THEN c.total_harga ELSE 0 END) KPB4, 
               SUM(CASE WHEN c.kode_jasa LIKE 'SL%' THEN c.total_harga ELSE 0 END) SL, 
               SUM(CASE WHEN c.kode_jasa LIKE 'SR%' THEN c.total_harga ELSE 0 END) SR, 
               SUM(c.total_harga) TOTAL_JASA, 0 TOTAL_PART 
        FROM workshops a 
        LEFT JOIN workshops_dtlservices c ON a.id = c.workshop_id 
        JOIN mst_employes e ON a.mekanik = e.employee_code
        WHERE a.trans_date >= '".$start."' AND a.trans_date <= '".$end."' 
          AND a.status != '1' AND c.status != '1' 
        GROUP BY a.mekanik 

        UNION ALL

        SELECT a.mekanik, e.nama_mekanik, 
               0 GO, 0 CS, 0 KPB1, 0 KPB2, 0 KPB3, 0 KPB4, 0 SL, 0 SR, 0 TOTAL_JASA, 
               SUM(b.total_harga) TOTAL_PART  
        FROM workshops a 
        LEFT JOIN workshops_dtlparts b ON a.id = b.workshop_id 
        JOIN mst_employes e ON a.mekanik = e.employee_code
        WHERE a.trans_date >= '".$start."' AND a.trans_date <= '".$end."' 
          AND a.status != '1' AND b.status != '1' 
        GROUP BY a.mekanik 
    ) Z
    GROUP BY Z.mekanik;
")->fetchAll('assoc');
  
		//  pr($result); 
		  
		  if(empty($result)){
				$this->Flash->set(__('Data tidak tersedia.'));
				return $this->redirect(['action' => 'index']);
			}
          switch ($this->request->getData('type')) {
            case 'html':
              $file = 'html';
              break;
            case 'excel':
              $file = 'excel';
              break;
            case 'pdf':
              $file = 'pdf';
              break;
            default:
              $file = 'html';
              break;
          }
		  		$periode = date("d F Y",strtotime($this->request->getData('start'))).' - '.date("d F Y",strtotime($this->request->getData('end')));
          $this->set(compact('data','periode','company','result'));
          $this->render($file);
        }
         $this->set(compact('data'));
    }

}
