<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
// Komentari atau hapus use statement yang tidak digunakan/diperlukan untuk mencegah error jika library tidak ada
// use PHPExcel;
// use PHPExcel_IOFactory;
// use Setasign\Fpdf;

class ReportKartuStocksController extends AppController
{
    // public $PhpExcel = null; // Hapus jika tidak digunakan

    public function index()
    {
        // Tidak perlu inisialisasi $conn di sui jika tidak digunakan sebelum POST
        if ($this->request->is('post')) {
            // Validasi dan sanitasi input
            $year = $this->request->getData('year');
            $month = $this->request->getData('month');
            $partno = $this->request->getData('partnumber');
            $exportType = $this->request->getData('type');

            // Validasi input dasar
            if (!$year || !$month || !$partno) {
                 $this->Flash->error(__('Mohon lengkapi semua field yang diperlukan.'));
                 return $this->redirect(['action' => 'index']);
            }

            $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
            $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
            $branchcode = $this->getRequest()->getSession()->read('Auth.branch_code');

            // Validasi dan format tanggal dengan aman
            $periode = $year . '-' . $month;
            $trx_date_start = date('Y-m-01', strtotime($periode . '-01')); // Tanggal awal periode (Y-m-01) untuk saldo awal
            if ($trx_date_start === false || $trx_date_start === '1970-01-01') {
                 $this->Flash->error(__('Format periode tidak valid.'));
                 return $this->redirect(['action' => 'index']);
            }

            $start = date('Y-m-01 00:00:00', strtotime($periode . '-01'));
            $end = date('Y-m-t 23:59:59', strtotime($periode . '-01'));

            // Cari deskripsi part
            $partdesc_table = $this->fetchTable('Masters.Parts');
            $partdesc = $partdesc_table->find()->where(['partnumber' => $partno])->first();
            if (!$partdesc) {
                $this->Flash->warning(__('Partnumber tidak ditemukan di master data.'));
                // Bisa diputuskan untuk lanjut atau tidak
                // return $this->redirect(['action' => 'index']);
            }

            // Gunakan ConnectionManager dan execute dengan binding parameter untuk keamanan
            $conn = ConnectionManager::get('default');

            // Query Utama: Gabungkan Saldo Awal Dinamis, Barang Masuk, dan Barang Keluar
            // Kita hitung saldo awal secara dinamis dari log_parts
            $fullQuery = "
                SELECT * FROM (
                    -- Saldo Awal Dinamis
                    SELECT
                        UUID() as id,
                        :trx_date_start as trx_date,
                        'Sawal' as trx_code,
                        :partno as part_no,
                        :partname as part_name,
                        COALESCE((SELECT warehouse_code FROM log_parts WHERE part_no = :partno_warehouse AND branch_code = :branchcode_warehouse AND trx_date < :start_datetime_warehouse ORDER BY trx_date DESC LIMIT 1), '') as warehouse_code,
                        :branchcode_main as branch_code,
                        COALESCE((SELECT rak_code FROM log_parts WHERE part_no = :partno_rak AND branch_code = :branchcode_rak AND trx_date < :start_datetime_rak ORDER BY trx_date DESC LIMIT 1), '') as rak_code,
                        COALESCE(SUM(CASE WHEN in_out = 'I' THEN qty ELSE 0 END), 0) -
                        COALESCE(SUM(CASE WHEN in_out = 'O' THEN qty ELSE 0 END), 0) as qty,
                        'Sawal' as in_out
                    FROM log_parts
                    WHERE
                        part_no = :partno_saldo AND
                        branch_code = :branchcode_saldo AND
                        trx_date < :start_datetime_saldo

                    UNION ALL

                    -- Barang Masuk (In)
                    SELECT
                        UUID() as id,
                        trx_date,
                        trx_code,
                        part_no,
                        part_name,
                        warehouse_code,
                        branch_code,
                        rak_code,
                        qty,
                        in_out
                    FROM log_parts
                    WHERE
                        in_out = 'I' AND
                        trx_date BETWEEN :start_period_in AND :end_period_in AND
                        part_no = :partno_in AND
                        branch_code = :branchcode_in

                    UNION ALL

                    -- Barang Keluar (Out)
                    SELECT
                        UUID() as id,
                        trx_date,
                        trx_code,
                        part_no,
                        part_name,
                        warehouse_code,
                        branch_code,
                        rak_code,
                        qty,
                        in_out
                    FROM log_parts
                    WHERE
                        in_out = 'O' AND
                        trx_date BETWEEN :start_period_out AND :end_period_out AND
                        part_no = :partno_out AND
                        branch_code = :branchcode_out
                ) a
                ORDER BY a.trx_date ASC
            ";

            try {
                // Eksekusi query dengan binding parameter - PASTIKAN SETIAP :placeholder ADA DI SINI
                $result = $conn->execute($fullQuery, [
                    // Parameter untuk Saldo Awal
                    'trx_date_start' => $trx_date_start,
                    'partno' => $partno,
                    'partname' => $partdesc ? $partdesc->partname : $partno, // Gunakan partnumber jika nama tidak ditemukan
                    'partno_warehouse' => $partno,
                    'branchcode_warehouse' => $branchcode,
                    'start_datetime_warehouse' => $start,
                    'partno_rak' => $partno,
                    'branchcode_rak' => $branchcode,
                    'start_datetime_rak' => $start,
                    'branchcode_main' => $branchcode,
                    'partno_saldo' => $partno,
                    'branchcode_saldo' => $branchcode,
                    'start_datetime_saldo' => $start,

                    // Parameter untuk Barang Masuk
                    'start_period_in' => $start,
                    'end_period_in' => $end,
                    'partno_in' => $partno,
                    'branchcode_in' => $branchcode,

                    // Parameter untuk Barang Keluar
                    'start_period_out' => $start,
                    'end_period_out' => $end,
                    'partno_out' => $partno,
                    'branchcode_out' => $branchcode
                ]);

                $data = $result->fetchAll('assoc');

                if (empty($data)) {
                    $this->Flash->warning(__('Data tidak tersedia untuk kriteria yang dipilih.'));
                    return $this->redirect(['action' => 'index']);
                }

                switch ($exportType) {
                    case 'excel':
                        $file = 'excel';
                        break;
                    case 'pdf': // Jika Anda memiliki template pdf
                        $file = 'pdf';
                        break;
                    case 'html':
                    default:
                        $file = 'html';
                        break;
                }

                // Pastikan $periode, $partno, $partdesc, $company dikirim ke view
                $this->set(compact('data', 'periode', 'partno', 'partdesc', 'company'));
                $this->render($file);
            } catch (\Exception $e) {
                 $this->Flash->error(__('Terjadi kesalahan saat mengambil data: ') . $e->getMessage());
                 // Opsional: Log error untuk debugging
                 // error_log("ReportKartuStocks Error: " . $e->getMessage());
                 return $this->redirect(['action' => 'index']);
            }
        }
        // Jika bukan POST, cukup render form kosong
    }
}