<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportTopSalesPartsController extends AppController
{

    public $PhpExcel = null;

    public function index()
    {
        $conn = ConnectionManager::get('default');
        if ($this->request->is('post')) {
          $this->loadModel('Transactions.Pkbs');
          $datas =$conn->execute("
            select a.partnumber,a.partdesc,sum(a.qtyIn) qtyIn, sum(a.totalIn) totalIn, sum(a.qtyOut) qtyOut, sum(a.totalOut) totalOut,(sum(qtyIn) - sum(qtyOut)) qty, (sum(totalIn) - sum(totalOut)) total
            from (
            select a.partnumber,c.description partdesc,sum(c.qty) qtyIn,sum(c.total) totalIn, 0 qtyOut, 0 totalOut from 
            workshops s join workshops_dtlparts a on s.id=a.workshop_id
            join payreceipts b on a.workshop_id =b.pkb_id
            join payreceipt_details c on b.id=c.payreceipt_id and a.partnumber=c.trans_code
            where trans_date between '".$this->request->getData('start')."' and  '".$this->request->getData('end')."'
            GROUP BY a.partnumber
            UNION ALL
            select b.partnumber,b.partdesc,sum(b.qty),sum(b.net_price), 0 qtyOut, 0 totalOut from 
            direct_sales a  join directsales_details b on a.id=b.directsales_id
            where directsales_date between '".$this->request->getData('start')."' and  '".$this->request->getData('end')."'
            GROUP BY b.partnumber

            UNION ALL
            select b.partnumber,b.partdesc, 0 qtyIn, 0 totalIn,sum(b.qty),sum(b.net_price) from 
            return_directsales a  join return_directsales_details b on a.id=b.ret_id
            where ret_date between '".$this->request->getData('start')."' and  '".$this->request->getData('end')."'
            GROUP BY b.partnumber

            ) a
            GROUP BY a.partnumber
            order by qty desc,total desc
            ");
          $data = $datas->fetchAll('assoc');  

          $dataBelis = $conn->execute("
            select a.partnumber, sum(a.total) total from 
              purchase_details a join purchases b on a.purchase_id=b.id
              where purchase_date between  '".$this->request->getData('start')."' and  '".$this->request->getData('end')."'
              GROUP by partnumber
          ");
           $dataBeli = $dataBelis->fetchAll('assoc');  
           $amountBeli=[];
           foreach ($dataBeli as $i => $v) {
             $amountBeli[$v['partnumber']] = $v['total'];
           }


         // dd($datas);
          if(empty($datas)){
            $this->Flash->set(__('Data tidak tersedia.'));
            return $this->redirect(['action' => 'index']);
          } 
          switch ($this->request->data('type')) {
            case 'html':
              $file = 'html';
              break;
            case 'excel':
              $file = 'excel';
              break;
            case 'pdf':
              $file = 'pdf';
              break;
            default:
              $file = 'html';
              break;
          }
          $periode = date("d F Y",strtotime($this->request->data('start'))).' - '.date("d F Y",strtotime($this->request->data('end')));
          $this->set(compact('data','periode','datas','amountBeli'));
          $this->render($file);
        }
    }

}
