<?php
namespace Masters\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

class JabatansTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
     public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('mst_jabatans');

        $this->addBehavior('Timestamp');

        
        
       
        
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
       
        $validator
            ->scalar('kode_jabatan')
            ->maxLength('kode_jabatan', 25)
            ->requirePresence('kode_jabatan', 'create')
            ->allowEmptyString('kode_jabatan', 'Kode Jabatan harus diisi', false)
            ;

        $validator
            ->scalar('nama_jabatan')
            ->maxLength('nama_jabatan', 45)
            ->requirePresence('nama_jabatan', 'create')
            ->allowEmptyString('nama_jabatan', 'Nama Jabatan harus diisi', false)
            ;

        return $validator;
    }

    
}
