<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Picqer\Barcode\BarcodeGeneratorPNG;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;

class BarcodesController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();
        $this->loadModel('MasterFile.MasterSpareparts');
    }

    public function index()
    {
        $parts = $this->MasterSpareparts->find('all');
        $this->set(compact('parts'));
    }

    public function generate1d($partnumber)
    {
        $part = $this->MasterSpareparts->findByPartnumber($partnumber)->firstOrFail();

        $generator = new BarcodeGeneratorPNG();
        $barcode = $generator->getBarcode($part->partnumber, $generator::TYPE_CODE_128);

        $this->response = $this->response->withType('image/png');
        $this->response = $this->response->withStringBody($barcode);
        return $this->response;
    }

    public function generate2d($partnumber)
    {
        $part = $this->MasterSpareparts->findByPartnumber($partnumber)->firstOrFail();

        $qrCode = QrCode::create($part->partnumber)
            ->setSize(300)
            ->setMargin(10)
            ->setWriter(new PngWriter());

        $dataUri = $qrCode->writeDataUri();

        $this->response = $this->response->withType('image/png');
        $this->response = $this->response->withStringBody(file_get_contents($dataUri));
        return $this->response;
    }
}
?>
