<?php
namespace UserPriviledges\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Groups Model
 *
 * @property \UserPriviledges\Model\Table\UsersTable|\Cake\ORM\Association\BelongsToMany $Users
 *
 * @method \UserPriviledges\Model\Entity\Group get($primaryKey, $options = [])
 * @method \UserPriviledges\Model\Entity\Group newEntity($data = null, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group[] newEntities(array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \UserPriviledges\Model\Entity\Group patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group[] patchEntities($entities, array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group findOrCreate($search, callable $callback = null, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class GroupsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('groups');
        $this->setDisplayField('title');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');
        // $this->belongsToMany('Users', [
        //     'className' => 'UserPriviledges.Users',
        //     'joinTable' => 'groups_users',
        //     'foreignKey' => 'group_id',
        //     'associationForeignKey' => 'user_id',
        //     'unique' => true,
        //     'conditions' => '',
        //     'fields' => '',
        //     'order' => '',
        //     'limit' => '',
        //     'offset' => '',
        //     'finderQuery' => '',
        //     'deleteQuery' => '',
        //     'insertQuery' => ''
        // ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        

        $validator
            ->scalar('title')
            ->maxLength('title', 60)
            ->requirePresence('title', 'create')
            ->notEmptyString('title');

        $validator
            ->scalar('description')
            ->maxLength('description', 255)
            ->requirePresence('description', 'create')
            ->notEmptyString('description');

        return $validator;
    }

    public function parentNode() {
        return null;
    }

}
