<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Pengeluaran Part - <?= $partsales->trx_code ?></title>
    <style>
        body {
            font-family: 'Courier New', monospace;
            font-size: 12px;
            line-height: 1.2;
            margin: 0;
            padding: 3mm 5mm;
            color: #000;
            background: #fff;
        }
        
        .container {
            width: 148mm;
            margin: 0;
            padding: 0;
        }
        
        .print-date {
            font-size: 10px;
            color: #000;
            margin-bottom: 5px;
        }
        
        .transaction-info {
            margin-bottom: 8px;
        }
        
        .info-row {
            margin-bottom: 2px;
        }
        
        .info-label {
            font-weight: bold;
            display: inline-block;
            width: 110px;
        }
        
        .header {
            text-align: center;
            margin: 8px 0 12px 0;
            padding: 5px 0;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }
        
        .header h1 {
            margin: 0;
            font-size: 14px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .header .subtitle {
            margin: 0;
            font-size: 12px;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 8px 0 15px 0;
            font-size: 11px;
        }
        
        .table th {
            background-color: #f0f0f0;
            border: 1px solid #000;
            padding: 3px 5px;
            text-align: left;
            font-weight: bold;
        }
        
        .table td {
            border: 1px solid #000;
            padding: 3px 5px;
            text-align: left;
        }
        
        .table .text-right {
            text-align: right;
        }
        
        .footer {
            margin-top: 15px;
            padding-top: 8px;
            border-top: 1px solid #000;
        }
        
        .signature-section {
            margin-top: 10px;
        }
        
        .signature-row {
            display: flex;
            justify-content: space-between;
        }
        
        .signature-box {
            width: 30%;
            text-align: center;
        }
        
        .signature-line {
            border-top: 1px solid #000;
            margin: 25px 0 3px 0;
            width: 100%;
        }
        
        .signature-name {
            font-weight: bold;
            margin-top: 2px;
        }
        
        .signature-date {
            font-size: 10px;
            margin-top: 1px;
        }
        
        .total-row {
            background-color: #f0f0f0 !important;
            font-weight: bold;
        }
        
        .no-print {
            display: none;
        }

        /* Print-specific styles */
        @media print {
            body {
                margin: 0;
                padding: 3mm 5mm;
                background: white;
            }
            
            .no-print {
                display: none !important;
            }
            
            @page {
                margin: 3mm 5mm;
                size: A5;
            }
        }

        /* Screen-specific styles */
        @media screen {
            body {
                background-color: #f5f5f5;
                padding: 15px;
            }
            
            .container {
                background: white;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
                border: 1px solid #ddd;
                padding: 15px;
            }
            
            .no-print {
                display: block;
                text-align: center;
                margin-bottom: 15px;
            }
            
            .print-controls button {
                padding: 6px 12px;
                margin: 0 3px;
                border: none;
                border-radius: 3px;
                cursor: pointer;
                font-size: 12px;
            }
            
            .btn-print {
                background: #007bff;
                color: white;
            }
            
            .btn-close {
                background: #dc3545;
                color: white;
            }
        }
    </style>
</head>
<body>
    <!-- Print Controls (Hidden when printing) -->
    <div class="no-print">
        <div style="text-align: center; padding: 8px; background: #f8f9fa; border-radius: 4px;">
            <button onclick="window.print()" class="btn-print">🖨️ Cetak</button>
            <button onclick="window.close()" class="btn-close">❌ Tutup</button>
        </div>
    </div>
    
    <div class="container">
        <!-- Print Date -->
        <div class="print-date">
            Dicetak pada: <?= date('d F Y H:i:s') ?>
        </div>
        
        <!-- Transaction Information -->
        <div class="transaction-info">
            <div class="info-row">
                <span class="info-label">Kode Transaksi</span>: <?= h($partsales->trx_code) ?>
            </div>
            <div class="info-row">
                <span class="info-label">Tanggal</span>: <?= $partsales->trx_date ? $partsales->trx_date->format('d F Y') : '-' ?>
            </div>
            <div class="info-row">
                <span class="info-label">Keterangan</span>: <?= h($partsales->trx_desc) ?: '-' ?>
            </div>
        </div>
        
        <!-- Header Title -->
        <div class="header">
            <h1>PENGELUARAN PART</h1>
            <div class="subtitle">LAPORAN PENGELUARAN BARANG</div>
        </div>
        
        <!-- Parts Table -->
        <table class="table">
            <thead>
                <tr>
                    <th width="8%">No</th>
                    <th width="32%">Part Number</th>
                    <th width="50%">Deskripsi</th>
                    <th width="10%">Qty</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $no = 1;
                $total_qty = 0;
                foreach($partsales->part_sales_details as $detail): 
                    $total_qty += $detail->qty;
                ?>
                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= h($detail->partnumber) ?></td>
                    <td><?= h($detail->partdesc) ?></td>
                    <td class="text-right"><?= number_format($detail->qty, 0) ?></td>
                </tr>
                <?php endforeach; ?>
                
                <!-- Total Row -->
                <tr class="total-row">
                    <td colspan="3" class="text-right"><strong>TOTAL</strong></td>
                    <td class="text-right"><strong><?= number_format($total_qty, 0) ?></strong></td>
                </tr>
            </tbody>
        </table>
        
        <!-- Footer Signatures -->
        <div class="footer">
            <div class="signature-section">
                <div class="signature-row">
                    <div class="signature-box">
                        <div>Dibuat oleh,</div>
                        <div class="signature-line"></div>
                        <div class="signature-name"><?= h($partsales->create_by_name) ?: 'Admin' ?></div>
                        <div class="signature-date">
                            <?= $partsales->created ? $partsales->created->format('d/m/Y H:i') : '' ?>
                        </div>
                    </div>
                    
                    <div class="signature-box">
                        <div>Disetujui oleh,</div>
                        <div class="signature-line"></div>
                        <div class="signature-name">Manager</div>
                        <div class="signature-date">&nbsp;</div>
                    </div>
                    
                    <div class="signature-box">
                        <div>Diterima oleh,</div>
                        <div class="signature-line"></div>
                        <div class="signature-name">&nbsp;</div>
                        <div class="signature-date">&nbsp;</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        window.onload = function() {
            // Auto print optional
            // window.print();
        };
    </script>
</body>
</html>