<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?=$this->Html->link('Home',['plugin'=>'SystemConfigurations','controller'=>'home','action'=>'index'])?></li>
                <li class="breadcrumb-item"><?=$this->Html->link('Transaction',['plugin'=>'Transactions','controller'=>'customers','action'=>'index'])?></li>
                <li class="breadcrumb-item"><?=$this->Html->link('Invoice Tagihan',['plugin'=>'Transactions','controller'=>'BillingInvoices','action'=>'index'])?></li>
                <li class="breadcrumb-item active">Tambah Invoice Baru</li>
            </ol>
        </div>
        
        <?php if($this->getRequest()->getSession()->read('Flash')): ?>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="alert alert-danger alert-dismissible fade show mb-3"><?= $this->Flash->render() ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></button></div>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="row">
            <div class="col-sm-12 col-xl-12">
                <?=$this->Form->create($invoice, ['class' => 'invoice-form']);?>
                
                <!-- Header Section dengan Informasi Pelanggan dan Ringkasan -->
                <div class="card mb-4">
                    <div class="card-header bg-gradient-primary text-white py-3">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <h4 class="mb-0 text-white"><i class="fas fa-file-invoice me-2"></i>Tambah Invoice Tagihan Baru</h4>
                                <small class="opacity-75"><?=date('d F Y H:i:s')?></small>
                                <?=$this->Form->control('invoice_date',['type'=>'hidden','value'=>date('Y-m-d')])?>
                            </div>
                            <div class="col-md-6 text-end">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="input-group input-group-sm mb-2">
                                            <span class="input-group-text bg-light"><i class="fas fa-search"></i></span>
                                            <input type="text" id="customer-search" class="form-control" placeholder="Cari pelanggan...">
                                        </div>
                                        <?=$this->Form->control('customer_id',['type'=>'hidden','id'=>'customer-id']);?>
                                    </div>
                                    <div class="col-md-4">
                                        <span class="badge bg-light text-primary fs-6">DRAFT</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <div class="row">
                            <!-- Informasi Pelanggan -->
                            <div class="col-md-6">
                                <h6 class="text-primary mb-3"><i class="fas fa-user me-2"></i>Informasi Pelanggan</h6>
                                <div class="row">
                                    <div class="col-md-6 mb-2">
                                        <label class="form-label small fw-semibold">Nama Pelanggan</label>
                                        <?=$this->Form->control('customer_name',[
                                            'label'=>false,
                                            'class'=>'form-control form-control-sm',
                                            'placeholder'=>'Nama lengkap',
                                            'id' => 'customer-name'
                                        ]);?>
                                    </div>
                                    <div class="col-md-6 mb-2">
                                        <label class="form-label small fw-semibold">Perusahaan</label>
                                        <?=$this->Form->control('customer_company',[
                                            'label'=>false,
                                            'class'=>'form-control form-control-sm',
                                            'placeholder'=>'Nama perusahaan',
                                            'id' => 'customer-company'
                                        ]);?>
                                    </div>
                                    <div class="col-md-6 mb-2">
                                        <label class="form-label small fw-semibold">Email</label>
                                        <?=$this->Form->control('customer_email',[
                                            'label'=>false,
                                            'class'=>'form-control form-control-sm',
                                            'placeholder'=>'email@perusahaan.com',
                                            'id' => 'customer-email'
                                        ]);?>
                                    </div>
                                    <div class="col-md-6 mb-2">
                                        <label class="form-label small fw-semibold">Telepon</label>
                                        <?=$this->Form->control('customer_phone',[
                                            'label'=>false,
                                            'class'=>'form-control form-control-sm',
                                            'placeholder'=>'08xxx',
                                            'id' => 'customer-phone'
                                        ]);?>
                                    </div>
                                    <div class="col-12 mb-2">
                                        <label class="form-label small fw-semibold">Alamat</label>
                                        <?=$this->Form->control('customer_address',[
                                            'label'=>false,
                                            'class'=>'form-control form-control-sm',
                                            'rows'=>2,
                                            'placeholder'=>'Alamat lengkap',
                                            'id' => 'customer-address'
                                        ]);?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Ringkasan Pembayaran -->
                            <div class="col-md-3">
                                <h6 class="text-primary mb-3"><i class="fas fa-calculator me-2"></i>Ringkasan</h6>
                                <div class="border rounded p-3 bg-light">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="small fw-semibold">Subtotal:</span>
                                        <?=$this->Form->control('subtotal',[
                                            'label'=>false,
                                            'class'=>'form-control border-0 bg-transparent text-end p-0 small fw-bold',
                                            'readonly'=>true,
                                            'id'=>'subtotal',
                                            'value' => 'Rp 0',
                                            'style' => 'width: 120px;'
                                        ]);?>
                                        <?=$this->Form->control('subtotal',[
                                            'type' => 'hidden',
                                            'value' => '0'
                                        ]);?>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <div class="d-flex align-items-center">
                                            <span class="small fw-semibold me-2">Pajak:</span>
                                            <div style="width: 60px;">
                                                <?=$this->Form->control('tax_rate',[
                                                    'label'=>false,
                                                    'class'=>'form-control form-control-sm text-center',
                                                    'value'=>0,
                                                    'id' => 'tax-rate'
                                                ]);?>
                                            </div>
                                            <span class="small">%</span>
                                        </div>
                                        <?=$this->Form->control('tax_amount',[
                                            'label'=>false,
                                            'class'=>'form-control border-0 bg-transparent text-end p-0 small',
                                            'readonly'=>true,
                                            'id'=>'tax-amount',
                                            'value' => 'Rp 0',
                                            'style' => 'width: 120px;'
                                        ]);?>
                                        <?=$this->Form->control('tax_amount',[
                                            'type' => 'hidden',
                                            'value' => '0'
                                        ]);?>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <span class="small fw-semibold">Diskon:</span>
                                        <?=$this->Form->control('discount_amount',[
                                            'label'=>false,
                                            'class'=>'form-control form-control-sm text-end',
                                            'value'=>0,
                                            'id'=>'discount-amount',
                                            'placeholder'=>'0',
                                            'style' => 'width: 120px;'
                                        ]);?>
                                    </div>
                                    <hr class="my-2">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold text-dark">Total:</span>
                                        <?=$this->Form->control('total_amount',[
                                            'label'=>false,
                                            'class'=>'form-control border-0 bg-transparent text-end p-0 fw-bold text-primary',
                                            'readonly'=>true,
                                            'id'=>'total-amount',
                                            'value' => 'Rp 0',
                                            'style' => 'width: 120px; font-size: 1.1em;'
                                        ]);?>
                                        <?=$this->Form->control('total_amount',[
                                            'type' => 'hidden',
                                            'value' => '0'
                                        ]);?>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Informasi Invoice & Keterangan -->
                            <div class="col-md-3">
                                <h6 class="text-primary mb-3"><i class="fas fa-cog me-2"></i>Pengaturan</h6>
                                <div class="mb-3">
                                    <label class="form-label small fw-semibold">Jenis Invoice</label>
                                    <?=$this->Form->control('invoice_type',[
                                        'label'=>false, 
                                        'required'=>true,
                                        'class'=>'form-control form-control-sm',
                                        'options'=>$invoiceTypes,
                                        'empty'=>' - Pilih Jenis -'
                                    ]);?>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label small fw-semibold">Jatuh Tempo</label>
                                    <?=$this->Form->control('due_date',[
                                        'label'=>false,
                                        'required'=>true,
                                        'class'=>'form-control form-control-sm',
                                        'type'=>'date',
                                        'value'=>$defaultDueDate
                                    ]);?>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label small fw-semibold">Metode Bayar</label>
                                    <?=$this->Form->control('payment_method',[
                                        'label'=>false,
                                        'class'=>'form-control form-control-sm',
                                        'options'=>$listpayment,
                                        'empty'=>' - Pilih -'
                                    ]);?>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label small fw-semibold">Status</label>
                                    <?=$this->Form->control('status',[
                                        'label'=>false,
                                        'class'=>'form-control form-control-sm',
                                        'options'=>[
                                            'draft' => 'Draft',
                                            'sent' => 'Terkirim',
                                            'paid' => 'Lunas'
                                        ],
                                        'value'=>'draft'
                                    ]);?>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Keterangan -->
                        <div class="row mt-3">
                            <div class="col-12">
                                <label class="form-label small fw-semibold text-primary">
                                    <i class="fas fa-sticky-note me-2"></i>Keterangan & Catatan
                                </label>
                                <?=$this->Form->control('description',[
                                    'label'=>false,
                                    'class'=>'form-control form-control-sm',
                                    'rows'=>2,
                                    'placeholder'=>'Keterangan tambahan, terms & conditions, atau catatan khusus untuk invoice...'
                                ]);?>
                            </div>
                        </div>
                    </div>
                </div>

               <!-- Items Section -->
                    <div class="card">
                        <div class="card-header bg-gradient-info text-white py-3 d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 text-white"><i class="fas fa-list-ul me-2"></i>Detail Item Tagihan</h5>
                            <button type="button" id="addRowItem" class="btn btn-light btn-sm" onclick="addRowItem()">
                                <i class="fas fa-plus me-1"></i>Tambah Item
                            </button>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table id="InvoiceItems" class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="45%" class="ps-4">Deskripsi Item/Layanan</th>
                                            <th width="12%" class="text-center">Qty</th>
                                            <th width="18%" class="text-end">Harga Satuan</th>
                                            <th width="18%" class="text-end">Total</th>
                                            <th width="7%" class="text-center">Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr id="tr_item_0" class="item-row">
                                            <td class="ps-4">
                                                <?=$this->Form->control('billing_invoice_items.0.description',[
                                                    'label'=>false,
                                                    'class'=>'form-control form-control-sm item-description',
                                                    'placeholder'=>'Deskripsi layanan/item'
                                                ]);?>
                                            </td>
                                            <td>
                                                <?=$this->Form->control('billing_invoice_items.0.quantity',[
                                                    'label'=>false,
                                                    'class'=>'form-control form-control-sm text-center quantity',
                                                    'value'=>1,
                                                    'type' => 'number',
                                                    'step' => '0.01',
                                                    'min' => '0'
                                                ]);?>
                                            </td>
                                            <td>
                                                <?=$this->Form->control('billing_invoice_items.0.unit_price',[
                                                    'label'=>false,
                                                    'class'=>'form-control form-control-sm text-end unit-price',
                                                    'placeholder'=>'0',
                                                    'type' => 'text'
                                                ]);?>
                                                <?=$this->Form->control('billing_invoice_items.0.unit_price_raw',[
                                                    'type' => 'hidden',
                                                    'value' => '0'
                                                ]);?>
                                            </td>
                                            <td>
                                                <?=$this->Form->control('billing_invoice_items.0.total_price_display',[
                                                    'label'=>false,
                                                    'class'=>'form-control form-control-sm text-end item-total-display',
                                                    'readonly'=>true,
                                                    'value' => 'Rp 0'
                                                ]);?>
                                                <?=$this->Form->control('billing_invoice_items.0.total_price',[
                                                    'type' => 'hidden',
                                                    'value' => '0'
                                                ]);?>
                                            </td>
                                            <td class="text-center">
                                                <button type="button" class="btn btn-outline-danger btn-sm" onclick="deleteRowItem(0)" disabled>
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                <!-- Action Buttons -->
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <button class="btn btn-outline-secondary btn-sl-sm me-2" type="reset">
                                    <i class="fas fa-undo me-2"></i>Reset Form
                                </button>
                                <?=$this->Html->link('<i class="fas fa-times me-2"></i>Batal',
                                    ['plugin'=>'Transactions','controller'=>'BillingInvoices','action'=>'index'],
                                    ['escape'=>false,'class'=>'btn btn-light btn-sl-sm']
                                )?>
                            </div>
                            <div>
                                <button class="btn btn-success btn-sl-sm me-2" type="submit" name="action" value="save_draft">
                                    <i class="fas fa-save me-2"></i>Simpan Draft
                                </button>
                                <button class="btn btn-primary btn-sl-sm" type="submit" name="action" value="save_send">
                                    <i class="fas fa-paper-plane me-2"></i>Simpan & Kirim
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <?=$this->Form->end();?>
            </div>
        </div>
    </div>
</div>

<?php
$this->Html->scriptStart(['block' => 'scriptBottom']);
?>
// JavaScript functions for billing invoice
let itemCounter = 0;

function addRowItem() {
    itemCounter++;
    const newRow = `
        <tr id="tr_item_${itemCounter}" class="item-row">
            <td class="ps-4">
                <input type="text" name="billing_invoice_items[${itemCounter}][description]" 
                    class="form-control form-control-sm item-description" 
                    placeholder="Deskripsi layanan/item">
            </td>
            <td>
                <input type="number" name="billing_invoice_items[${itemCounter}][quantity]" 
                    class="form-control form-control-sm text-center quantity" 
                    value="1" step="0.01" min="0"
                    oninput="calculateItemTotal(${itemCounter})">
            </td>
            <td>
                <input type="text" name="billing_invoice_items[${itemCounter}][unit_price]" 
                    class="form-control form-control-sm text-end unit-price" 
                    placeholder="0"
                    oninput="calculateItemTotal(${itemCounter})">
                <input type="hidden" name="billing_invoice_items[${itemCounter}][unit_price_raw]" 
                    value="0">
            </td>
            <td>
                <input type="text" name="billing_invoice_items[${itemCounter}][total_price_display]" 
                    class="form-control form-control-sm text-end item-total-display" 
                    readonly
                    value="Rp 0">
                <input type="hidden" name="billing_invoice_items[${itemCounter}][total_price]" 
                    value="0">
            </td>
            <td class="text-center">
                <button type="button" class="btn btn-outline-danger btn-sm" 
                    onclick="deleteRowItem(${itemCounter})">
                    <i class="fas fa-trash"></i>
                </button>
            </td>
        </tr>
    `;
    $('#InvoiceItems tbody').append(newRow);
    
    // Enable delete button for first row if there are multiple rows
    if (itemCounter >= 1) {
        $('#tr_item_0 .btn-outline-danger').prop('disabled', false);
    }
    
    initCurrencyFormat();
    attachEventListeners();
}

function deleteRowItem(rowId) {
    if ($('#InvoiceItems tbody tr').length > 1) {
        $(`#tr_item_${rowId}`).remove();
        calculateTotals();
        
        // Disable delete button for first row if only one row remains
        if ($('#InvoiceItems tbody tr').length === 1) {
            $('#tr_item_0 .btn-outline-danger').prop('disabled', true);
        }
    }
}

function calculateItemTotal(rowId) {
    console.log('Calculating for row:', rowId);
    
    const quantityInput = $(`[name="billing_invoice_items[${rowId}][quantity]"]`);
    const unitPriceInput = $(`[name="billing_invoice_items[${rowId}][unit_price]"]`);
    const unitPriceRawInput = $(`[name="billing_invoice_items[${rowId}][unit_price_raw]"]`);
    const totalDisplayInput = $(`[name="billing_invoice_items[${rowId}][total_price_display]"]`);
    const totalRawInput = $(`[name="billing_invoice_items[${rowId}][total_price]"]`);
    
    const quantity = parseFloat(quantityInput.val()) || 0;
    const unitPrice = parseCurrency(unitPriceInput.val());
    const total = quantity * unitPrice;
    
    console.log('Qty:', quantity, 'Unit Price:', unitPrice, 'Total:', total);
    
    // Update display value (formatted)
    totalDisplayInput.val(formatCurrency(total));
    
    // Update raw value for form submission (numeric)
    totalRawInput.val(total);
    unitPriceRawInput.val(unitPrice);
    
    calculateTotals();
}

function parseCurrency(currencyString) {
    if (!currencyString || currencyString === '') return 0;
    // Remove all non-digit characters except decimal point
    const cleanString = currencyString.replace(/[^\d,]/g, '').replace(',', '');
    return parseFloat(cleanString) || 0;
}

function calculateTotals() {
    console.log('Calculating totals...');
    
    let subtotal = 0;
    
    // Calculate subtotal from all items
    $('input[name$="[total_price]"]').each(function() {
        const value = parseFloat($(this).val()) || 0;
        subtotal += value;
    });
    
    const taxRate = parseFloat($('#tax-rate').val()) || 0;
    const taxAmount = subtotal * (taxRate / 100);
    const discountAmount = parseCurrency($('#discount-amount').val());
    const totalAmount = subtotal + taxAmount - discountAmount;
    
    console.log('Subtotal:', subtotal, 'Tax:', taxAmount, 'Discount:', discountAmount, 'Total:', totalAmount);
    
    // Update display values
    $('#subtotal').val(formatCurrency(subtotal));
    $('#tax-amount').val(formatCurrency(taxAmount));
    $('#total-amount').val(formatCurrency(totalAmount));
    
    // Update hidden form fields with raw values for submission
    $('input[name="subtotal"]').val(subtotal.toFixed(2));
    $('input[name="tax_amount"]').val(taxAmount.toFixed(2));
    $('input[name="total_amount"]').val(totalAmount.toFixed(2));
    $('input[name="tax_rate"]').val(taxRate.toFixed(2));
    $('input[name="discount_amount"]').val(discountAmount.toFixed(2));
}

function formatCurrency(amount) {
    if (isNaN(amount) || amount === 0) return 'Rp 0';
    return 'Rp ' + new Intl.NumberFormat('id-ID').format(Math.round(amount));
}

function initCurrencyFormat() {
    // Format unit price on blur
    $(document).on('blur', '.unit-price', function() {
        const value = parseCurrency($(this).val());
        if (value > 0) {
            $(this).val(formatCurrency(value));
        } else {
            $(this).val('');
        }
    });
    
    // Format discount amount on blur
    $(document).on('blur', '#discount-amount', function() {
        const value = parseCurrency($(this).val());
        if (value > 0) {
            $(this).val(formatCurrency(value));
        } else {
            $(this).val('0');
        }
        calculateTotals();
    });
    
    // Clear formatting on focus for easy editing
    $(document).on('focus', '.unit-price, #discount-amount', function() {
        const value = parseCurrency($(this).val());
        $(this).val(value > 0 ? value : '');
    });
}

function attachEventListeners() {
    // Attach input events to all quantity and unit price fields
    $(document).off('input', '.quantity, .unit-price').on('input', '.quantity, .unit-price', function() {
        const rowId = $(this).closest('tr').attr('id').split('_')[2];
        calculateItemTotal(rowId);
    });
    
    // Attach input event to tax rate
    $(document).off('input', '#tax-rate').on('input', '#tax-rate', function() {
        calculateTotals();
    });
}

// Customer search autocomplete
$(document).ready(function() {
    $('#customer-search').autocomplete({
        source: '<?=$this->Url->build('/transactions/billing-invoices/getCustomers', ['fullBase'=>true])?>',
        minLength: 2,
        select: function(event, ui) {
            $('#customer-id').val(ui.item.id);
            $('#customer-name').val(ui.item.data.name);
            $('#customer-company').val(ui.item.data.company);
            $('#customer-email').val(ui.item.data.email);
            $('#customer-phone').val(ui.item.data.phone);
            $('#customer-address').val(ui.item.data.address);
        }
    });
    
    // Initialize calculations and event listeners
    initCurrencyFormat();
    attachEventListeners();
    calculateTotals();
    
    // Add some styling for better UX
    $('.card').addClass('shadow-sm');
    $('.form-control').addClass('rounded');
    
    // Initial calculation for first row
    calculateItemTotal(0);
});
<?php
$this->Html->scriptEnd();
?>

<style>
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
}

.bg-gradient-info {
    background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%) !important;
}

.card {
    border: none;
    border-radius: 12px;
}

.card-header {
    border-radius: 12px 12px 0 0 !important;
    border: none;
}

.form-control {
    border: 1px solid #e3e6f0;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #74b9ff;
    box-shadow: 0 0 0 0.2rem rgba(116, 185, 255, 0.25);
}

.table th {
    border-top: none;
    font-weight: 600;
    font-size: 0.875rem;
    text-transform: uppercase;
    color: #6c757d;
}

.item-row:hover {
    background-color: #f8f9fa;
}

.btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.badge {
    font-size: 0.75rem !important;
}

.shadow-sm {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
}

.rounded {
    border-radius: 8px !important;
}

.bg-light {
    background-color: #f8f9fa !important;
}

.small {
    font-size: 0.875em;
}

.item-total {
    background-color: #f8f9fa !important;
    font-weight: 600 !important;
}
</style>