<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;

class StockOpnamesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    /*** Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';

        $query = $this->StockOpnames->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'trx_code LIKE' => '%' . $search . '%',
                    'proses LIKE' => '%' . $search . '%',
                    'trx_date' => $search,
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('StockOpnames.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('StockOpnames.created desc');
        
        $stockopname = $this->paginate($query);

        $this->set(compact('data','stockopname'));           


    }
    public function proses($id){
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';
        if ($this->request->is('post')) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $getdata = $this->StockOpnames->find()
                        ->contain(['StockOpnameDetails'])->where(['StockOpnames.id'=>$id])->first();
            $transLog=[];            
            if($getdata){
                foreach($getdata->stock_opname_details as $i=>$v){
                    $v->branch_id = '907fdaf2-5455-41e9-8d1b-ffe2482d656a';
                    $partHarga = $this->fetchTable('Masters.Parts')->find()->where(['partnumber'=>$v->partnumber])->first();   
                    $branch_code = $this->fetchTable('UserPriviledges.Branches')->find()->where(['Branches.id'=>$v->branch_id])->first();    
                    $rak_id = $this->fetchTable('Masters.Raks')->find()->where(['Raks.rak_code'=>$v->rak_code])->first();               
                    $transLog['trx_code'] = $getdata->trx_code;
                    $transLog['trx_date'] = date('Y-m-d H:i:s');
                    $transLog['part_no'] =  $v->partnumber;
                    $transLog['part_name'] = $v->partdesc;
                    $transLog['in_out'] = 'I';
                    $transLog['qty'] = $v->qty_delta;
                    $transLog['warehouse_code'] = $getdata->warehouse_code;
                    $transLog['warehouse_id'] = $getdata->warehouse_id;
                    $transLog['rak_code'] = $v->rak_code;
                    $transLog['rak_id'] = $rak_id->id;
                    $transLog['branch_code'] = $branch_code->branch_code;
                    $transLog['branch_id'] = $v->branch_id;

                    $logpartTable = $this->fetchTable('Transactions.LogParts');
                    $logs = $logpartTable->newEntity($transLog);
                   
                    $resulLogs = $logpartTable->save($logs);
                    if($resulLogs){
                        $parttable = $this->fetchTable('Transactions.StockParts');
                        $getStocks = $parttable->find()->where(['partnumber'=>$v->partnumber,'rak'=>$v->rak_code,'warehouse_code'=>$getdata->warehouse_code])->first();

                        if($getStocks){
                                 //update
                          $getStocks->harga = $partHarga->harga;       
                          $getStocks->qty = $getStocks->qty + $v->qty_delta; 
                          if(!$parttable->save($getStocks)){
                                $setStatus = 0;
                                $message = 'Fail update stocks. Please, try again.';
                                break;
                          }      
                       }else{
                            $mstStock['warehouse_code'] = $getdata->warehouse_code;
                            $mstStock['warehouse_name'] = $getdata->warehouse_name;
                            $mstStock['warehouse_id'] = $getdata->warehouse_id;
                            $mstStock['branch_code'] = $branch_code->branch_code;
                            $mstStock['branch_id'] = $v->branch_id;
                            $mstStock['rak_id'] =  $rak_id->id;
                            $mstStock['rak'] = $v->rak_code;
                            $mstStock['partnumber'] = $v->partnumber;
                            $mstStock['partdesc'] = $v->partdesc;
                            $mstStock['qty'] = $v->qty1;
                            $mstStock['harga'] = $partHarga->harga;
                            $mstStock['created'] = date('Y-m-d H:i:s');;
                            $mstStock['create_by'] = $this->getRequest()->getSession()->read('Auth.id');
                            $mstStock['modified'] = date('Y-m-d H:i:s');
                            $mstStock['modi_by'] = $this->getRequest()->getSession()->read('Auth.id');
                            // dd($mstStock);
                            $stocks = $parttable->newEntity($mstStock);
                            if(!$parttable->save($stocks)){
                                  $setStatus = 0;
                                  $message = 'Fail update stocks. Please, try again.';
                                  break;
                            }else{
                                $setStatus = 1;
                                $message = 'The data has been saved.';
                            }
                       }

                    }else{
                        $setStatus = 0;
                        $message = 'The log parts could not be saved. Please, try again.';
                        break;
                    }   


                }
                $updateStatus = $this->StockOpnames->updateALL(['proses'=>'Y'],['StockOpnames.id'=>$id]);
                if(!$updateStatus){
                    $setStatus = 0;
                    $message = 'The data could not be saved. Please, try again.';
                }else{
                    $setStatus = 1;
                    $message = 'The data has been saved.';
                }

                $this->Flash->set(__($message));

                if($setStatus){
                    $connection->commit();
                }else {
                    $connection->rollback();
                }

                return $this->redirect(['action' => 'index']);
            }            
        }
    }

    public function edit($id){
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';
        $stockopname = $this->StockOpnames->get($id, contain: ['StockOpnameDetails']);
        if($stockopname->proses == 'Y'){
            $this->Flash->set(__('Sudah dilakukan proses stockopname !'));
            $this->redirect(['action' => 'index']);
        }
        if ($this->request->is('put')) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $stockopname = $this->StockOpnames->patchEntity($stockopname, $this->request->getData());
            $stockopname->trx_date=date('Y-m-d',strtotime($this->request->getData('trx_date')));
           
            $stockopname->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $stockopname->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            $stockopname->branch_code= $this->getRequest()->getSession()->read('Auth.branch_code');
            $stockopname->branch_id= $this->getRequest()->getSession()->read('Auth.branch_id');

            //gudang
            $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code'=>$stockopname->branch_code])->select(['id','kode_gudang','nama_gudang'])->first();  

            $stockopname->warehouse_code= $getwarehouseID->kode_gudang;
            $stockopname->warehouse_id= $getwarehouseID->id;
            $stockopname->warehouse_name= $getwarehouseID->nama_gudang;



            foreach ($stockopname->stock_opname_details as $i => $v) {

                $stockopname->stock_opname_details[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                $stockopname->stock_opname_details[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                $stockopname->stock_opname_details[$i]->created = date("Y-m-d H:i:s");
                $stockopname->stock_opname_details[$i]->modified = date("Y-m-d H:i:s");
                $stockopname->stock_opname_details[$i]->branch_code= $this->getRequest()->getSession()->read('Auth.branch_code');
                $stockopname->stock_opname_details[$i]->branch_id= $this->getRequest()->getSession()->read('Auth.branch_id');
                $getrak = $this->fetchTable('Masters.Raks')->find()->where(['rak_code'=>$v->rak_code,'branch_code'=>$v->branch_code])->select(['id','rak_code'])->first();  
                $stockopname->stock_opname_details[$i]->rak_id = $getrak->id;
            }
            if ($this->StockOpnames->save($stockopname,[ 'associated' => ['StockOpnameDetails']])) {
                    $setStatus = 1;
                    $message = 'The data has been saved.';

            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }

            if($setStatus){
                $connection->commit();
                $this->Flash->set(__($message));
                return $this->redirect(['action' => 'index']);
            }else {
                $this->Flash->set(__($message));
                $connection->rollback();
            }
        }
        $this->set(compact('data','stockopname'));
        $this->set('_serialize', ['data','stockopname']);
    }

    public function view($id){
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';
        $stockopname = $this->StockOpnames->get($id, contain: ['StockOpnameDetails']);
        $this->set(compact('data','stockopname'));
    }

    public function add(){
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';
        $this->loadComponent('General');
        $stockopname = $this->StockOpnames->newEmptyEntity();
        if ($this->request->is('post')) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $stockopname = $this->StockOpnames->patchEntity($stockopname, $this->request->getData());
            $stockopname->trx_date=date('Y-m-d',strtotime($this->request->getData('trx_date')));
            $stockopname->trx_code=$this->General->__sinchronizeID('ST',date('ym'),5,array('val_id','val_char', 'val_value'));
            $stockopname->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $stockopname->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            $stockopname->branch_code= $this->getRequest()->getSession()->read('Auth.branch_code');
            $stockopname->branch_id= $this->getRequest()->getSession()->read('Auth.branch_id');

            //gudang
            $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code'=>$stockopname->branch_code])->select(['id','kode_gudang','nama_gudang'])->first();  

            $stockopname->warehouse_code= $getwarehouseID->kode_gudang;
            $stockopname->warehouse_id= $getwarehouseID->id;
            $stockopname->warehouse_name= $getwarehouseID->nama_gudang;



            foreach ($stockopname->stock_opname_details as $i => $v) {
                if($v->qty > 0){
                    $stockopname->stock_opname_details[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                    $stockopname->stock_opname_details[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                    $stockopname->stock_opname_details[$i]->created = date("Y-m-d H:i:s");
                    $stockopname->stock_opname_details[$i]->modified = date("Y-m-d H:i:s");
                    $stockopname->stock_opname_details[$i]->branch_code= $stockopname->branch_code;
                    $stockopname->stock_opname_details[$i]->branch_id=$stockopname->branch_id;
                    $getrak = $this->fetchTable('Masters.Raks')->find()->where(['rak_code'=>$v->rak_code,'branch_code'=>$v->branch_code])->select(['id','rak_code'])->first();  
                    $stockopname->stock_opname_details[$i]->rak_id = $getrak->id;
                }    
            }
            if ($this->StockOpnames->save($stockopname,[ 'associated' => ['StockOpnameDetails']])) {
                    $setStatus = 1;
                    $message = 'The data has been saved.';

            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }

            if($setStatus){
                $connection->commit();
                $this->Flash->set(__($message));
                return $this->redirect(['action' => 'index']);
            }else {
                $this->Flash->set(__($message));
                $connection->rollback();
            }
        }
        $this->set(compact('stockopname','data'));  
    }

    function getstocks($partnumber,$rak){
        $this->autoRender = false;
        $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code')])->select(['id','kode_gudang','nama_gudang'])->first(); 
        $parttable = $this->fetchTable('Transactions.StockParts');
        $getStocks = $parttable->find()->where(['partnumber'=>$partnumber,'rak'=>$rak,'warehouse_code'=>$getwarehouseID->kode_gudang])->first();
        if($getStocks){
            $data = $getStocks->qty;
        }else{
            $data=0;
        }
        
        $this->response = $this->response->withType('application/json')
                                         ->withStringBody(json_encode($data));

        // Return the response
        return $this->response;
    }

    function getSparepart($partnumber){
        // $warehouseTable = $this->fetchTable('Masters.Warehouses');
        // $getWarehouse = $warehouseTable->find()->where(['branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code')])->first();
        $parttable = $this->fetchTable('Masters.Parts');
        $getParts = $parttable->find()
                    ->where([
                            'partnumber'=>$partnumber,
                            // 'branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code'),
                            // 'warehouse_code'=>$getWarehouse->kode_gudang
                            ])
                        ->first();
        echo json_encode($getParts);
        exit;
    }
    public function getpartdetail(){
        $this->autoRender = false;
        $keyword = $this->request->getQuery('term');

        $parttable = $this->fetchTable('Masters.Parts');
        
        $suggestions = $parttable
            ->find('list',
            keyField : 'partnumber',
            valueField : 'partnumber'
            )->where(['partnumber LIKE' => '%' . $keyword . '%'])
            ->toArray();
        foreach($suggestions as $i=>$v){
            $result[$i] = ['id'=>$i,'label'=>$v,'value'=>$v];
        }
        echo json_encode($result);
        exit;



        
    }

}