<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;

class StockOpnamesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    
    public function index()
    {
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';

        $query = $this->StockOpnames->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'trx_code LIKE' => '%' . $search . '%',
                    'proses LIKE' => '%' . $search . '%',
                    'trx_date' => $search,
                ]
            ]);
        }

        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('StockOpnames.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        } else {
             $query = $query->order('StockOpnames.created desc');
        }
        
        $stockopname = $this->paginate($query);

        $this->set(compact('data','stockopname'));           
    }
    
    public function proses($id)
    {
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';

        if ($this->request->is('post')) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $setStatus = 1;
            $message = '';

            try {
                $getdata = $this->StockOpnames->find()
                            ->contain(['StockOpnameDetails'])
                            ->where(['StockOpnames.id' => $id])
                            ->firstOrFail();

                $branch = $this->fetchTable('UserPriviledges.Branches')->find()->where(['Branches.id' => $getdata->branch_id])->firstOrFail();
                $parts = $this->fetchTable('Masters.Parts')->find('list', ['keyField' => 'partnumber', 'valueField' => 'harga'])->toArray();
                $raks = $this->fetchTable('Masters.Raks')->find('list', ['keyField' => 'rak_code', 'valueField' => 'id'])->toArray();

                foreach ($getdata->stock_opname_details as $v) {
                    $partHarga = $parts[$v->partnumber] ?? 0;
                    $rak_id = $raks[$v->rak_code] ?? null;

                    $in_out = ($v->qty_delta > 0) ? 'I' : 'O';

                    $transLog = [
                        'trx_code' => $getdata->trx_code,
                        'trx_date' => date('Y-m-d H:i:s'),
                        'part_no' => $v->partnumber,
                        'part_name' => $v->partdesc,
                        'in_out' => $in_out,
                        'qty' => abs($v->qty_delta),
                        'warehouse_code' => $getdata->warehouse_code,
                        'warehouse_id' => $getdata->warehouse_id,
                        'rak_code' => $v->rak_code,
                        'rak_id' => $rak_id,
                        'branch_code' => $branch->branch_code,
                        'branch_id' => $getdata->branch_id,
                    ];
                    
                    $logpartTable = $this->fetchTable('Transactions.LogParts');
                    $logs = $logpartTable->newEntity($transLog);
                    if (!$logpartTable->save($logs)) {
                        throw new \Exception('Gagal menyimpan log untuk part: ' . $v->partnumber . '. Kesalahan: ' . json_encode($logs->getErrors()));
                    }
                    
                    $parttable = $this->fetchTable('Transactions.StockParts');
                    $getStocks = $parttable->find()->where([
                        'partnumber' => $v->partnumber,
                        'rak' => $v->rak_code,
                        'warehouse_code' => $getdata->warehouse_code
                    ])->first();

                    if ($getStocks) {
                        $getStocks->harga = $partHarga;
                        $getStocks->qty += $v->qty_delta;
                        if (!$parttable->save($getStocks)) {
                            throw new \Exception('Gagal memperbarui stok untuk part: ' . $v->partnumber . '. Kesalahan: ' . json_encode($getStocks->getErrors()));
                        }
                    } else {
                        $mstStock = [
                            'warehouse_code' => $getdata->warehouse_code,
                            'warehouse_name' => $getdata->warehouse_name,
                            'warehouse_id' => $getdata->warehouse_id,
                            'branch_code' => $branch->branch_code,
                            'branch_id' => $getdata->branch_id,
                            'rak_id' => $rak_id,
                            'rak' => $v->rak_code,
                            'partnumber' => $v->partnumber,
                            'partdesc' => $v->partdesc,
                            'qty' => $v->qty1,
                            'harga' => $partHarga,
                            'created' => date('Y-m-d H:i:s'),
                            'create_by' => $this->getRequest()->getSession()->read('Auth.id'),
                            'modified' => date('Y-m-d H:i:s'),
                            'modi_by' => $this->getRequest()->getSession()->read('Auth.id'),
                        ];
                        $stocks = $parttable->newEntity($mstStock);
                        if (!$parttable->save($stocks)) {
                            throw new \Exception('Gagal membuat entri stok baru untuk part: ' . $mstStock['partnumber'] . '. Kesalahan: ' . json_encode($stocks->getErrors()));
                        }
                    }
                }
                
                $updateStatus = $this->StockOpnames->updateAll(['proses' => 'Y'], ['StockOpnames.id' => $id]);
                if (!$updateStatus) {
                    throw new \Exception('Gagal memperbarui status proses Stock Opname. Mohon hubungi administrator.');
                }
                
                $connection->commit();
                $message = 'Data berhasil diproses dan disimpan.';
            } catch (\Exception $e) {
                $connection->rollback();
                $setStatus = 0;
                $message = 'Proses Gagal. ' . $e->getMessage();
            }

            if ($setStatus === 1) {
                $this->Flash->success(__($message));
            } else {
                $this->Flash->error(__($message));
            }
            return $this->redirect(['action' => 'index']);
        }
    }

    public function edit($id)
    {
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';
        $stockopname = $this->StockOpnames->get($id, contain: ['StockOpnameDetails']);

        if($stockopname->proses == 'Y'){
            $this->Flash->error(__('Sudah dilakukan proses stockopname!'));
            return $this->redirect(['action' => 'index']);
        }

        if ($this->request->is(['put', 'post'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $setStatus = 1;
            $message = '';
            
            try {
                $this->patchAndSave($stockopname, $this->request->getData());
                $connection->commit();
                $message = 'Data berhasil diubah dan disimpan.';
            } catch (\Exception $e) {
                $connection->rollback();
                $setStatus = 0;
                $message = 'Gagal menyimpan. ' . $e->getMessage();
            }
            
            if ($setStatus === 1) {
                $this->Flash->success(__($message));
            } else {
                $this->Flash->error(__($message));
            }

            if ($setStatus) {
                return $this->redirect(['action' => 'index']);
            }
        }
        $this->set(compact('data','stockopname'));
        $this->set('_serialize', ['data','stockopname']);
    }

    public function view($id)
    {
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';
        $stockopname = $this->StockOpnames->get($id, contain: ['StockOpnameDetails']);
        $this->set(compact('data','stockopname'));
    }

    public function add()
    {
        $data['titlePage'] = 'Stock Opname';
        $data['titleMenu'] = 'Stock Opname';
        $this->loadComponent('General');
        $stockopname = $this->StockOpnames->newEmptyEntity();

        if ($this->request->is('post')) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $setStatus = 1;
            $message = '';

            try {
                $stockopname->trx_code = $this->General->__sinchronizeID('ST', date('ym'), 5, ['val_id','val_char', 'val_value']);
                $this->patchAndSave($stockopname, $this->request->getData());
                $connection->commit();
                $message = 'Data berhasil disimpan.';
            } catch (\Exception $e) {
                $connection->rollback();
                $setStatus = 0;
                $message = 'Gagal menyimpan. ' . $e->getMessage();
            }

            if ($setStatus === 1) {
                $this->Flash->success(__($message));
            } else {
                $this->Flash->error(__($message));
            }

            if ($setStatus) {
                return $this->redirect(['action' => 'index']);
            }
        }
        $this->set(compact('stockopname','data'));
    }
    
    // Private method to reduce code repetition
    private function patchAndSave($stockopname, $requestData)
    {
        $stockopname = $this->StockOpnames->patchEntity($stockopname, $requestData, [
            'associated' => ['StockOpnameDetails']
        ]);
        
        $stockopname->trx_date = date('Y-m-d', strtotime($requestData['trx_date']));
        $stockopname->create_by = $this->getRequest()->getSession()->read('Auth.id');
        $stockopname->modi_by = $this->getRequest()->getSession()->read('Auth.id');
        $stockopname->branch_code = $this->getRequest()->getSession()->read('Auth.branch_code');
        $stockopname->branch_id = $this->getRequest()->getSession()->read('Auth.branch_id');

        $getwarehouse = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code' => $stockopname->branch_code])->select(['id', 'kode_gudang', 'nama_gudang'])->firstOrFail();
        $stockopname->warehouse_code = $getwarehouse->kode_gudang;
        $stockopname->warehouse_id = $getwarehouse->id;
        $stockopname->warehouse_name = $getwarehouse->nama_gudang;

        foreach ($stockopname->stock_opname_details as $i => $v) {
            $v->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $v->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            $v->created = date("Y-m-d H:i:s");
            $v->modified = date("Y-m-d H:i:s");
            $v->branch_code = $stockopname->branch_code;
            $v->branch_id = $stockopname->branch_id;

            // Perbaikan: Tambahkan nilai default untuk qty2, qty3, dan qty_adjus
            $v->qty2 = 0;
            $v->qty3 = 0;
            $v->qty_adjus = 0;

            $getrak = $this->fetchTable('Masters.Raks')->find()->where(['rak_code' => $v->rak_code, 'branch_code' => $v->branch_code])->select(['id', 'rak_code'])->firstOrFail();
            $v->rak_id = $getrak->id;
        }

        if (!$this->StockOpnames->save($stockopname)) {
            throw new \Exception('Gagal menyimpan data Stock Opname. Kesalahan: ' . json_encode($stockopname->getErrors()));
        }
    }

    function getstocks($partnumber, $rak)
    {
        $this->autoRender = false;
        $getwarehouse = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code' => $this->getRequest()->getSession()->read('Auth.branch_code')])->select(['kode_gudang'])->first();
        $parttable = $this->fetchTable('Transactions.StockParts');
        $getStocks = $parttable->find()->where(['partnumber' => $partnumber, 'rak' => $rak, 'warehouse_code' => $getwarehouse->kode_gudang])->first();
        $data = $getStocks ? $getStocks->qty : 0;
        
        $this->response = $this->response->withType('application/json')->withStringBody(json_encode($data));
        return $this->response;
    }

    function getSparepart($partnumber)
    {
        $this->autoRender = false;
        $parttable = $this->fetchTable('Masters.Parts');
        $getParts = $parttable->find()->where(['partnumber' => $partnumber])->first();

        $this->response = $this->response->withType('application/json')->withStringBody(json_encode($getParts));
        return $this->response;
    }
    
    public function getpartdetail()
    {
        $this->autoRender = false;
        $keyword = $this->request->getQuery('term');
        $parttable = $this->fetchTable('Masters.Parts');
        
        $suggestions = $parttable
            ->find('list',
                keyField : 'id',
                valueField : 'partnumber'
            )->where(['partnumber LIKE' => '%' . $keyword . '%'])
            ->toArray();
            
        $result = [];
        foreach($suggestions as $i => $v) {
            $result[] = ['id' => $v, 'label' => $v, 'value' => $v];
        }

        $this->response = $this->response->withType('application/json')->withStringBody(json_encode($result));
        return $this->response;
    }
}