<?php
declare(strict_types=1);

namespace SystemConfigurations\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Reports\Controller\ReportPelangganBarusController;
use Cake\I18n\FrozenTime; // Tambahkan import FrozenTime
use Cake\ORM\TableRegistry; // Tambahkan import TableRegistry

class HomeController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Dashboard';
        $conn = ConnectionManager::get('default');

        $startDate = date('Y-m-01');
        $endDate = date('Y-m-t');
        
        // --- Hitung Pelanggan Baru (AWAL) ---
        $invoicesTable = TableRegistry::getTableLocator()->get('Transactions.Invoices'); // Dapatkan instance tabel

       // Pelanggan baru hari ini
        $todayStart = FrozenTime::now()->startOfDay()->toDateTimeString();
        $todayEnd = FrozenTime::now()->endOfDay()->toDateTimeString();
        
        // Subquery untuk mendapatkan pelanggan yang sudah ada SEBELUM hari ini
        $existingCustomersToday = $invoicesTable->find()
            ->select(['nopol']) // GANTI nopol jika perlu
            ->where(['trans_date <' => $todayStart, 'status !=' => '1'])
            ->distinct(['nopol']); // GANTI nopol jika perlu
        
        $pelangganBaruHariIni = $invoicesTable->find()
            ->where([
                'trans_date BETWEEN :start AND :end',
                'status !=' => '1',
                'NOT' => ['nopol IN' => $existingCustomersToday] // Ini yang penting!
            ])
            ->bind(':start', $todayStart, 'datetime')
            ->bind(':end', $todayEnd, 'datetime')
            ->distinct(['nopol'])  // GANTI nopol jika perlu!
            ->count();
        
        debug($pelangganBaruHariIni); // Tambahkan ini


        // Pelanggan baru bulan ini
        $startOfMonth = FrozenTime::now()->startOfMonth();
        $endOfMonth = FrozenTime::now()->endOfMonth();
        $existingCustomers = $invoicesTable->find()
            ->select(['nopol'])
            ->where(['trans_date <' => $startOfMonth, 'status !=' => '1']) // Pelanggan sebelum bulan ini
            ->distinct(['nopol']);

        $pelangganBaruBulanIni = $invoicesTable->find()
            ->where([
                'trans_date >=' => $startOfMonth,
                'trans_date <=' => $endOfMonth,
                'status !=' => '1', // Tambahkan kondisi status
                'NOT' => ['nopol IN' => $existingCustomers]  // Hindari pelanggan lama
            ])
            ->distinct(['nopol'])  // Ganti 'nopol' jika perlu
            ->count();
        // --- Hitung Pelanggan Baru (AKHIR) ---

        $dataparts = $conn->execute("select month(a.trans_date) day, sum(b.total_harga) total 
                                     from workshops a join workshops_dtlparts b on a.id = b.workshop_id 
                                     where year(a.trans_date) ='".date('Y')."' and a.status != '1' and b.status != '1' 
                                     group by month(a.trans_date)");
        $datapart = $dataparts->fetchAll('assoc');  

        $nparts = []; // Inisialisasi array $npart
        foreach ($datapart as $i => $v) {
            $v['day'] = (int) $v['day'];
            $nparts[$v['day']] = (int) $v['total'];
        }

        $m = 0;
        for ($n = 1; $n <= 12; $n++) {
            if (!isset($nparts[$n])) {
                $npart[(int)$m] = 0;
            } else {
                $npart[(int)$m] = $nparts[$n];
            }
            $m++;
        }

        $jasas = $conn->execute("select month(a.trans_date) day, sum(b.total_harga) total 
                                 from workshops a join workshops_dtlservices b on a.id = b.workshop_id 
                                 where year(a.trans_date) ='".date('Y')."' and a.status != '1' and b.status != '1' 
                                 group by month(a.trans_date)");
        $jasa = $jasas->fetchAll('assoc');  

        $njasas = [];
        foreach ($jasa as $i => $v) {
            $v['day'] = (int) $v['day'];
            $njasas[$v['day']] = (int) $v['total'];
        }

        $m = 0;
        for ($n = 1; $n <= 12; $n++) {
            if (!isset($njasas[$n])) {
                $njasa[(int)$m] = 0;
            } else {
                $njasa[(int)$m] = $njasas[$n];
            }
            $m++;
        }

        // Menghitung jumlah entri unit bulanan, mengabaikan status = '1'
        $getUnitEntryMonth = $this->fetchTable('Transactions.Invoices')->find()
            ->where([
                "trans_date between '$startDate' and '$endDate'",
                'status !=' => '1'
            ])
            ->count();

        // Menghitung jumlah entri unit harian, mengabaikan status = '1'
        $getUnitEntryDaily = $this->fetchTable('Transactions.Invoices')->find()
            ->where([
                "trans_date between '".date('Y-m-d 00:00:00')."' and '".date('Y-m-d 23:59:59')."'",
                'status !=' => '1'
            ])
            ->count();

        $getParts = $conn->execute("
            select sum(total_harga) total 
            from workshops_dtlparts 
            where created between '".$startDate."' and '".$endDate."' and status != '1'
        ");
        $getPart = $getParts->fetchAll('assoc'); 

        $getJasas = $conn->execute("
            select sum(total_harga) total 
            from workshops_dtlservices 
            where created between '".$startDate."' and '".$endDate."' and status != '1'
        ");
        $getJasa = $getJasas->fetchAll('assoc');

        if ($getJasa[0]['total'] == null) {
            $getJasa[0]['total'] = 0;
        }
        if ($getPart[0]['total'] == null) {
            $getPart[0]['total'] = 0;
        }

        // Top Salesman
        $topsalesmans = $conn->execute("
            select a.mekanik, b.nama_mekanik, count(a.id) total 
            from workshops a 
            join mst_employes b on a.mekanik = b.employee_code 
            where a.trans_date between '".$startDate."' and '".$endDate."' and a.status != '1' 
            group by a.mekanik, b.nama_mekanik 
            order by total desc limit 10
        ");
        $topsalesman = $topsalesmans->fetchAll('assoc'); 

        // Top Customer
        $topcustomers = $conn->execute("
            select a.nopol, a.nama, count(a.id) total 
            from workshops a 
            join mst_customers b on a.nopol = b.nopol 
            where a.trans_date between '".$startDate."' and '".$endDate."' and a.status != '1' 
            group by a.nopol, a.nama 
            order by total desc limit 10
        ");
        $topcustomer = $topcustomers->fetchAll('assoc');  

        // Top Part
        $topParts = $conn->execute("
            select a.partnumber, a.partdesc, sum(a.qty) total 
            from workshops_dtlparts a 
            join workshops b on a.workshop_id = b.id 
            where b.trans_date between '".$startDate."' and '".$endDate."' and b.status != '1' and a.status != '1' 
            group by a.partnumber, a.partdesc 
            order by total desc limit 10
        ");
        $topPart = $topParts->fetchAll('assoc'); 

        $partSeries = [];
        $partlabel = [];
        if ($topPart) {
            foreach ($topPart as $i => $v) {
                $partSeries[] = (int)$v['total'];
                $partlabel[] = $v['partdesc'];
            }
        }

       $this->set(compact('data', 'njasa', 'npart', 'getUnitEntryMonth', 'getUnitEntryDaily', 'getPart', 'getJasa',
    'topsalesman', 'topPart', 'partSeries', 'partlabel', 'topcustomer', 'pelangganBaruHariIni', 'pelangganBaruBulanIni'));

       if ($this->getRequest()->getSession()->read('Auth.groups.0.title') == 'Manager') {
    $this->render('home_manager');
    } elseif ($this->getRequest()->getSession()->read('Auth.groups.0.title') == 'Stok') {
    // Langsung redirect tanpa render view
    return $this->redirect('/masters/Stocks');
    } else {
    $this->render('index');

        }        
    }
}
