<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

$fileName = 'report_pembelian.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', $company['address']);
$sheet->setCellValue('A4', 'Report Pembelian');
$sheet->setCellValue('A5', 'Tanggal');
$sheet->setCellValue('B5', $periode);

$sheet->mergeCells('A1:J1');
$sheet->mergeCells('A2:J2');
$sheet->mergeCells('A4:B4');

$sheet->getStyle('A1:A2')->getFont()->setBold(true);
$sheet->getStyle('A4')->getFont()->setSize(14)->setBold(true);
$sheet->getStyle('A5:B5')->getFont()->setBold(true);

$row = 7; // Initialize row number for headers
$sheet->setCellValue('A'.$row, 'Tanggal');
$sheet->setCellValue('B'.$row, 'Kode');
$sheet->setCellValue('C'.$row, 'Kode Ref');
$sheet->setCellValue('D'.$row, 'Kode Supplier');
$sheet->setCellValue('E'.$row, 'Nama Supplier');
$sheet->setCellValue('F'.$row, 'Partnumber');
$sheet->setCellValue('G'.$row, 'PartName');
$sheet->setCellValue('H'.$row, 'Qty');
$sheet->setCellValue('I'.$row, 'Harga');
$sheet->setCellValue('J'.$row, 'Total');

$sheet->getStyle('A'.$row.':J'.$row)->getFont()->setBold(true);
$sheet->getStyle('A'.$row.':J'.$row)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFFFE0B2');

$row = 8; // Start row for data
foreach ($dataReports as $i => $v) {
    $purchaseDate = \PhpOffice\PhpSpreadsheet\Shared\Date::stringToExcel(date('d-m-Y', strtotime($v['purchase_date'])));

    $sheet->setCellValue('A'.$row, $purchaseDate);
    $sheet->setCellValue('B'.$row, $v['purchase_code']);
    $sheet->setCellValue('C'.$row, $v['purchase_ref']);
    $sheet->setCellValue('D'.$row, $v['supplier_code']);
    $sheet->setCellValue('E'.$row, $v['supplier_name']);
    $sheet->setCellValue('F'.$row, $v['partnumber']);
    $sheet->setCellValue('G'.$row, $v['partdesc']);
    $sheet->setCellValue('H'.$row, $v['qty']);
    $sheet->setCellValue('I'.$row, $v['price']);
    $sheet->setCellValue('J'.$row, $v['total']);

    $sheet->getStyle('A'.$row)->getNumberFormat()->setFormatCode('DD-MM-YYYY'); // Format date
    $sheet->getStyle('I'.$row.':J'.$row)->getNumberFormat()->setFormatCode('#,##0'); // Format as currency without decimals
    $row++;
}

$sheet->setCellValue('I'.$row, 'Grand Total');
$sheet->setCellValue('J'.$row, $grandTotal);
$sheet->getStyle('I'.$row.':J'.$row)->getFont()->setBold(true);
$sheet->getStyle('I'.$row.':J'.$row)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFCCFFCC');
$sheet->getStyle('J'.$row)->getNumberFormat()->setFormatCode('#,##0'); // Format grand total as currency without decimals

$sheet->getStyle('A7:J'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

// Apply autosize to all columns
foreach (range('A', 'J') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
exit;
?>
