<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;

// debug($result); // Uncomment untuk debugging
// debug($company); // Uncomment untuk debugging
// debug($periode); // Uncomment untuk debugging

$fileName = 'LaporanPelangganBaru.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Judul dan Periode
$sheet->setCellValue('A1', $company['name'] ?? 'Nama Perusahaan Tidak Tersedia');
$sheet->setCellValue('A2', 'Periode: ' . ($periode ?? 'Periode Tidak Tersedia'));
$sheet->setCellValue('A4', 'Laporan Pelanggan Baru');
$sheet->getStyle('A1:A4')->getFont()->setBold(true);
$sheet->mergeCells('A1:C1');
$sheet->mergeCells('A2:C2');
$sheet->mergeCells('A4:C4');

$row = 6;

// Header Tabel
$sheet->setCellValue('A'.$row, 'Tanggal Transaksi');
$sheet->setCellValue('B'.$row, 'Nomor Polisi');
$sheet->setCellValue('C'.$row, 'Tipe Motor');
$sheet->getStyle('A'.$row.':C'.$row)->getFont()->setBold(true);
$sheet->getStyle('A'.$row.':C'.$row)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
$sheet->getStyle('A'.$row.':C'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
$sheet->getStyle('A'.$row.':C'.$row)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFD3D3D3');

$row++;

// Isi Tabel
if (!empty($result)) {
    foreach ($result as $v) {
        $sheet->setCellValue('A'.$row, $v->trans_date->format('d/m/Y'));
        $sheet->setCellValue('B'.$row, $v->nopol);
        $sheet->setCellValue('C'.$row, $v->type_mtr);
        $sheet->getStyle('A'.$row.':C'.$row)->getBorders()->