<?= $this->Flash->render() ?>
<?php debug($data); ?>
<div class="content-body">
    <div class="container-fluid">
        <?php if (!empty($data)): ?>
            <?php foreach (['newCustomers', 'dailyCustomers', 'monthlyCustomers', 'yearlyCustomers'] as $key): ?>
                <?php if (!empty($data[$key])): ?>
                    <h2>
                        <?php
                        $formattedStartDate = $startDate ? $startDate->format('d-m-Y') : '-';
                        $formattedEndDate = $endDate ? $endDate->format('d-m-Y') : '-';

                        switch ($key) {
                            case 'newCustomers':
                                echo "Data Pelanggan Baru (" . $formattedStartDate . " s/d " . $formattedEndDate . ")";
                                break;
                            case 'dailyCustomers':
                                echo "Jumlah Pelanggan Baru Harian (" . $formattedStartDate . " s/d " . $formattedEndDate . ")";
                                break;
                            case 'monthlyCustomers':
                                echo "Jumlah Pelanggan Baru Bulanan (" . $formattedStartDate . " s/d " . $formattedEndDate . ")";
                                break;
                            case 'yearlyCustomers':
                                echo "Jumlah Pelanggan Baru Tahunan (" . $formattedStartDate . " s/d " . $formattedEndDate . ")";
                                break;
                        }
                        ?>
                    </h2>
                    <div class="table-responsive">
                        <table class="table table-responsive-md table-sm mb-0 table-striped">
                            <thead>
                                <tr>
                                    <?php if ($key == 'newCustomers'): ?>
                                        <th>Nopol</th>
                                        <th>Type Mtr</th>
                                        <th>Tanggal Transaksi Pertama</th>
                                    <?php elseif ($key == 'dailyCustomers'): ?>
                                        <th>Tanggal</th>
                                        <th>Jumlah Pelanggan Baru</th>
                                    <?php elseif ($key == 'monthlyCustomers'): ?>
                                        <th>Bulan</th>
                                        <th>Jumlah Pelanggan Baru</th>
                                    <?php elseif ($key == 'yearlyCustomers'): ?>
                                        <th>Tahun</th>
                                        <th>Jumlah Pelanggan Baru</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($data[$key] as $item): ?>
                                    <tr>
                                        <?php if ($key == 'newCustomers'): ?>
                                            <td><?= h($item['nopol']) ?></td>
                                            <td><?= h($item['type_mtr']) ?></td>
                                            <td><?= h($item['first_trans_date']) ?></td>
                                        <?php elseif ($key == 'dailyCustomers'): ?>
                                            <td><?= h($item['trans_date']) ?></td>
                                            <td><?= h($item['total_new_customers']) ?></td>
                                        <?php elseif ($key == 'monthlyCustomers'): ?>
                                            <td><?= h($item['trans_month']) ?></td>
                                            <td><?= h($item['total_new_customers']) ?></td>
                                        <?php elseif ($key == 'yearlyCustomers'): ?>
                                            <td><?= h($item['trans_year']) ?></td>
                                            <td><?= h($item['total_new_customers']) ?></td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p>Tidak ada data <?php if (isset($key)) echo strtolower(str_replace('Customers', ' pelanggan baru', $key)); ?> untuk periode ini.</p>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<script>
$(document).ready(function () {
    $('.datepicker').datepicker({
        autoclose: true,
        format: "yyyy-mm-dd",
        dateFormat: "yy-mm-dd"
    });
});
</script>