<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

$fileName = 'report_bengkel_harian.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set company name and date
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', 'Tanggal : ' . $periode);
$sheet->setCellValue('A4', 'Report Bengkel Harian');
$sheet->getStyle('A1:A4')->getFont()->setBold(true);
$sheet->mergeCells('A1:E1');
$sheet->mergeCells('A2:E2');
$sheet->mergeCells('A4:E4');

$row = 6;

// Table headers
$sheet->setCellValue('A'.$row, 'Tanggal');
$sheet->setCellValue('B'.$row, 'Kode Invoice');
$sheet->setCellValue('C'.$row, 'Nopol');
/*$sheet->setCellValue('D'.$row, 'Type Service');*/
$sheet->setCellValue('D'.$row, 'Motor');
$sheet->setCellValue('E'.$row, 'Mekanik');
$sheet->setCellValue('F'.$row, 'Tipe Bayar');
$sheet->setCellValue('G'.$row, 'Total Cash');
$sheet->setCellValue('H'.$row, 'Total QRIS');
$sheet->setCellValue('I'.$row, 'Total EDC');
$sheet->setCellValue('J'.$row, 'Total Transfer');
$sheet->setCellValue('K'.$row, 'Total Piutang');
$sheet->setCellValue('L'.$row, 'Grand Total');

$sheet->getStyle('A'.$row.':L'.$row)->getFont()->setBold(true);
$sheet->getStyle('A'.$row.':L'.$row)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
$sheet->getStyle('A'.$row.':L'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
$sheet->getStyle('A'.$row.':L'.$row)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFD3D3D3');

$row++;

$totalcash = $totalqris = $totaledc = $totaltransfer = $totalpiutang = $grandtotal = 0;

foreach ($result as $i => $v) {
    $total = ($v['total_jasa'] + $v['total_part']) - $v['disc'];
    switch ($v['tipe_bayar']) {
        case 0:
            $tcash = $total;
            $tqris = $tedc = $ttransfer = $tpiutang = 0;
            break;
        case 1:
            $tqris = $total;
            $tcash = $tedc = $ttransfer = $tpiutang = 0;
            break;
        case 2:
            $ttransfer = $total;
            $tcash = $tqris = $tedc = $tpiutang = 0;
            break;
        case 3:
            $tedc = $total;
            $tcash = $tqris = $ttransfer = $tpiutang = 0;
            break;
        case 4:
            $tpiutang = $total;
            $tcash = $tqris = $tedc = $ttransfer = 0;
            break;
        default:
            $tcash = $total;
            $tqris = $tedc = $ttransfer = $tpiutang = 0;
    }

    $sheet->setCellValue('A'.$row, $v['trans_date']);
    $sheet->setCellValue('B'.$row, $v['kode_workshop']);
    $sheet->setCellValue('C'.$row, $v['nopol']);
    /*$sheet->setCellValue('D'.$row, $v['nama_jasa']);*/
    $sheet->setCellValue('D'.$row, $v['type_mtr']);
    $sheet->setCellValue('E'.$row, $v['nama_mekanik']);
    $sheet->setCellValue('F'.$row, $listpayment[$v['tipe_bayar']]);
    $sheet->setCellValue('G'.$row, $tcash);
    $sheet->setCellValue('H'.$row, $tqris);
    $sheet->setCellValue('I'.$row, $tedc);
    $sheet->setCellValue('J'.$row, $ttransfer);
    $sheet->setCellValue('K'.$row, $tpiutang);
    $sheet->setCellValue('L'.$row, $total);

    $sheet->getStyle('G'.$row.':L'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
    $sheet->getStyle('A'.$row.':L'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

    $totalcash += $tcash;
    $totalqris += $tqris;
    $totaledc += $tedc;
    $totaltransfer += $ttransfer;
    $totalpiutang += $tpiutang;
    $grandtotal += $total;

    $row++;
}

// Total row
$sheet->setCellValue('A'.$row, 'Total');
$sheet->mergeCells('A'.$row.':F'.$row);
$sheet->setCellValue('G'.$row, $totalcash);
$sheet->setCellValue('H'.$row, $totalqris);
$sheet->setCellValue('I'.$row, $totaledc);
$sheet->setCellValue('J'.$row, $totaltransfer);
$sheet->setCellValue('K'.$row, $totalpiutang);
$sheet->setCellValue('L'.$row, $grandtotal);

$sheet->getStyle('A'.$row.':L'.$row)->getFont()->setBold(true);
$sheet->getStyle('G'.$row.':L'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
$sheet->getStyle('A'.$row.':L'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

$row++;
$row++;

// Additional Data Section
$sheet->setCellValue('D'.$row, 'Total UE');
$sheet->setCellValue('E'.$row, sizeof($result));
$sheet->getStyle('D'.$row.':E'.$row)->getFont()->setBold(true);

$total = ($kas['pendapatan'][0]['jasa'] + $kas['pendapatan'][0]['part']) - $kas['pendapatan'][0]['disc'];
$tPengeluaran = $kas['pengeluaran_kas'][0]['total'] + $kas['pengeluaran_kas_other'][0]['total'];
$ttotal = $total - $tPengeluaran;

$row++;
$sheet->setCellValue('A'.$row, 'Pendapatan Cash');
$sheet->getStyle('A'.$row)->getFont()->setBold(true);
$row++;
$sheet->setCellValue('A'.$row, 'Jasa Cash');
$sheet->setCellValue('B'.$row, $kas['pendapatan'][0]['jasa']);
$sheet->getStyle('B'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
$row++;
$sheet->setCellValue('A'.$row, 'Part Cash');
$sheet->setCellValue('B'.$row, $kas['pendapatan'][0]['part']);
$sheet->getStyle('B'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
$row++;
$sheet->setCellValue('A'.$row, 'Disk TipeBayar Cash');
$sheet->setCellValue('B'.$row, $kas['pendapatan'][0]['disc']);
$sheet->getStyle('B'.$row)->getNumberFormat()->setFormatCode('#,##0.00');

$row++;
$sheet->setCellValue('A'.$row, 'Pengeluaran Kas');
$sheet->getStyle('A'.$row)->getFont()->setBold(true);
$row++;
$sheet->setCellValue('A'.$row, 'Kas Kecil');
$sheet->setCellValue('B'.$row, $kas['pengeluaran_kas'][0]['total']);
$sheet->getStyle('B'.$row)->getNumberFormat()->setFormatCode('#,##0.00');
$row++;
$sheet->setCellValue('A'.$row, 'Other');
$sheet->setCellValue('B'.$row, $kas['pengeluaran_kas_other'][0]['total']);
$sheet->getStyle('B'.$row)->getNumberFormat()->setFormatCode('#,##0.00');

$row++; $sheet->setCellValue('A'.$row, 'Setoran CASH');
$sheet->setCellValue('B'.$row, 'Rp '.number_format($ttotal, 2, ',', '.'));
$sheet->getStyle('A'.$row)->getFont()->setBold(true); $sheet->getStyle('B'.$row)->getFont()->setBold(true);

// Apply autosize to all columns
foreach (range('A', 'M') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

// Output to browser
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName) .'"');
$writer->save('php://output');
exit;
?>
