<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use DateTime;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPenjualanPartsController extends AppController
{
    public $PhpExcel = null;

    public function index()
    {
        $conn = ConnectionManager::get('default');
        $data['titlePage'] = 'Report Penjualan Part';
        $data['titleMenu'] = 'Report Penjualan Part';

        if ($this->request->is('post')) {
            $start = $this->request->getData('start');
            $end = $this->request->getData('end');

            // Validasi input tanggal
            if (!$start || !$end || !strtotime($start) || !strtotime($end)) {
                $this->Flash->error(__('Tanggal tidak valid.'));
                return $this->redirect(['action' => 'index']);
            }

            try {
                // Query untuk data penjualan part
                $result = $conn->execute("
                    SELECT a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, e.employee_code, 
                           c.partnumber, c.partdesc, sub.total_qty, 
                           (c.price * sub.total_qty * (1 - (c.diskon/100))) AS total_sales, 
                           c.total_harga, c.price, c.diskon, c.created
                    FROM workshops a 
                    LEFT JOIN (
                        SELECT workshop_id, partnumber, SUM(qty) as total_qty
                        FROM workshops_dtlparts
                        GROUP BY workshop_id, partnumber
                    ) sub ON a.id = sub.workshop_id
                    LEFT JOIN workshops_dtlparts c ON a.id = c.workshop_id AND sub.partnumber = c.partnumber
                    LEFT JOIN purchase_details pd ON c.partnumber = pd.partnumber
                    LEFT JOIN mst_employes e ON a.mekanik = e.employee_code
                    WHERE a.trans_date >= :start AND a.trans_date <= :end 
                        AND a.status != '1' 
                        AND c.status != '1'
                    GROUP BY a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, e.employee_code, 
                             c.partnumber, c.partdesc, sub.total_qty, c.total_harga, c.price, c.diskon, c.created
                    ORDER BY a.trans_date ASC", ['start' => $start, 'end' => $end])->fetchAll('assoc');

                // Query untuk pendapatan jasa service per mekanik
                $pendapatanJasa = $conn->execute("
                    SELECT e.employee_code, e.nama_mekanik, SUM(b.total_harga - b.diskon) AS jasa
                    FROM workshops a 
                    JOIN workshops_dtlservices b ON a.id = b.workshop_id
                    JOIN mst_employes e ON a.mekanik = e.employee_code
                    WHERE trans_date BETWEEN :start AND :end 
                        AND a.status != '1' 
                        AND b.status != '1'
                    GROUP BY e.employee_code, e.nama_mekanik
                ", ['start' => $start, 'end' => $end])->fetchAll('assoc');

                // Hitung HPP dan profit untuk setiap part
                foreach ($result as &$data) {
                    $partnumber = $data['partnumber'];
                    $transDate = $data['trans_date'];

                    $hpp = $conn->execute("
                        SELECT h.harga_beli
                        FROM part_price_history h
                        WHERE h.partnumber = :partnumber
                          AND h.valid_from <= :trans_date
                          AND (h.valid_to IS NULL OR h.valid_to >= :trans_date)
                        ORDER BY h.valid_from DESC
                        LIMIT 1", ['partnumber' => $partnumber, 'trans_date' => $transDate])->fetch('assoc');

                    if ($hpp) {
                        $data['total_hpp'] = $data['total_qty'] * $hpp['harga_beli'];
                    } else {
                        $part = $conn->execute("
                            SELECT harga_beli 
                            FROM mst_parts 
                            WHERE partnumber = :partnumber", ['partnumber' => $partnumber])->fetch('assoc');
                        $data['total_hpp'] = $data['total_qty'] * ($part['harga_beli'] ?? 0);
                    }

                    $data['profit'] = $data['total_sales'] - $data['total_hpp'];
                }

                // Hitung total profit per mekanik dari penjualan part
                $profitPartPerMekanik = [];
                foreach ($result as $item) {
                    if (!isset($profitPartPerMekanik[$item['employee_code']])) {
                        $profitPartPerMekanik[$item['employee_code']] = [
                            'nama_mekanik' => $item['nama_mekanik'],
                            'profit_part' => 0
                        ];
                    }
                    $profitPartPerMekanik[$item['employee_code']]['profit_part'] += $item['profit'];
                }

                // Gabungkan data profit part dan jasa per mekanik
                $profitPerMekanik = [];
                foreach ($profitPartPerMekanik as $employee_code => $data) {
                    $profitPerMekanik[$employee_code] = [
                        'nama_mekanik' => $data['nama_mekanik'],
                        'profit_part' => $data['profit_part'],
                        'profit_jasa' => 0
                    ];
                }

                // Tambahkan profit jasa
                foreach ($pendapatanJasa as $jasa) {
                    if (!isset($profitPerMekanik[$jasa['employee_code']])) {
                        $profitPerMekanik[$jasa['employee_code']] = [
                            'nama_mekanik' => $jasa['nama_mekanik'],
                            'profit_part' => 0,
                            'profit_jasa' => 0
                        ];
                    }
                    $profitPerMekanik[$jasa['employee_code']]['profit_jasa'] = $jasa['jasa'];
                }

                // Hitung total profit per mekanik
                foreach ($profitPerMekanik as &$mekanik) {
                    $mekanik['total_profit'] = $mekanik['profit_part'] + $mekanik['profit_jasa'];
                }

                // Hitung total keseluruhan
                $totalProfitPart = array_sum(array_column($result, 'profit'));
                $totalProfitJasa = array_sum(array_column($pendapatanJasa, 'jasa'));
                $totalProfit = $totalProfitPart + $totalProfitJasa;

            } catch (\Exception $e) {
                $this->Flash->error(__('Terjadi kesalahan saat mengambil data: ' . $e->getMessage()));
                return $this->redirect(['action' => 'index']);
            }

            if (empty($result) && empty($pendapatanJasa)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            $company = [
                'name' => 'AHASS RAJAWALI PUTERA',
                'address' => '-'
            ];

            $periode = date("d F Y", strtotime($start)) . ' - ' . date("d F Y", strtotime($end));
            
            $this->set(compact(
                'data', 
                'periode', 
                'company', 
                'result', 
                'profitPerMekanik',
                'totalProfitPart', 
                'totalProfitJasa', 
                'totalProfit'
            ));

            switch ($this->request->getData('type')) {
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $this->render($file);
        }

        $this->set(compact('data'));
    }
}