<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use DateTime; // Penting untuk perbandingan tanggal
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPenjualanPartHppsController extends AppController
{
    public function index()
    {
        $conn = ConnectionManager::get('default');
        $data['titlePage'] = 'Report Penjualan Part HPP';
        $data['titleMenu'] = 'Report Penjualan Part HPP';
        
       

        if ($this->request->is('post')) {
            $start = $this->request->getData('start');
            $end = $this->request->getData('end');

            if (!$start || !$end || !strtotime($start) || !strtotime($end)) {
                $this->Flash->error(__('Tanggal tidak valid.'));
                return $this->redirect(['action' => 'index']);
            }

            try {
                $result = $conn->execute("
                    SELECT a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, 
                        (c.price * sub.total_qty * (1 - (c.diskon/100))) AS total_sales, c.total_harga, c.price, c.diskon, c.created
                    FROM workshops a 
                    LEFT JOIN (
                        SELECT workshop_id, partnumber, SUM(qty) as total_qty
                        FROM workshops_dtlparts
                        GROUP BY workshop_id, partnumber
                    ) sub ON a.id = sub.workshop_id
                    LEFT JOIN workshops_dtlparts c ON a.id = c.workshop_id AND sub.partnumber = c.partnumber
                    LEFT JOIN mst_employes e ON a.mekanik = e.employee_code  -- Removed unnecessary join to purchase_details
                    WHERE a.trans_date >= :start AND a.trans_date <= :end 
                        AND a.status != '1' 
                        AND c.status != '1'
                    GROUP BY a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, c.total_harga, c.price, c.diskon, c.created
                    ORDER BY a.trans_date ASC", ['start' => $start, 'end' => $end])->fetchAll('assoc');

                $pendapatanJasa = $conn->execute("
                    SELECT SUM(b.total_harga - b.diskon) AS jasa
                    FROM workshops a 
                    JOIN workshops_dtlservices b 
                    ON a.id = b.workshop_id
                    WHERE trans_date BETWEEN :start AND :end 
                        AND a.status != '1' 
                        AND b.status != '1'
                ", ['start' => $start, 'end' => $end])->fetch('assoc');

            } catch (\Exception $e) {
                $this->Flash->error(__('Terjadi kesalahan saat mengambil data: ' . $e->getMessage()));
                return $this->redirect(['action' => 'index']);
            }

            if (empty($result)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            $this->loadModel('Transactions.HppHistoris'); // Load model HppHistoris

            foreach ($result as &$data) {
                $partnumber = $data['partnumber'];
                $totalQty = $data['total_qty'];
                $data['hpp_effective_date'] = $hppData['hpp_effective_date'];

                // Optimized HPP calculation using a single query
                $hppData = $conn->execute("
                    SELECT COALESCE(mp.harga_beli, latest_purchase.harga_per_qty) AS hpp_per_unit,
                           COALESCE(mp.modified, latest_purchase.created) AS hpp_effective_date
                    FROM mst_parts mp
                    LEFT JOIN (
                        SELECT pd.partnumber, (pd.total / pd.qty) AS harga_per_qty, pd.created
                        FROM purchase_details pd
                        INNER JOIN (
                            SELECT partnumber, MAX(created) AS max_created
                            FROM purchase_details
                            GROUP BY partnumber
                        ) AS latest ON pd.partnumber = latest.partnumber AND pd.created = latest.max_created
                        WHERE pd.partnumber = :partnumber  -- Filter directly in the subquery
                    ) AS latest_purchase ON mp.partnumber = latest_purchase.partnumber
                    WHERE mp.partnumber = :partnumber", ['partnumber' => $partnumber])->fetch('assoc');


                if ($hppData) {
                  $data['total_hpp'] = $totalQty * $hppData['hpp_per_unit'];
                    $hppEffectiveDate = new DateTime($hppData['hpp_effective_date']);
                } else {
                    $errorMessage = "Tidak ada data pembelian dan harga beli untuk partnumber: " . $partnumber;
                    \Cake\Log\Log::error($errorMessage);
                    $data['total_hpp'] = 0;
                    $hppEffectiveDate = null; // or handle appropriately
                }


                $data['profit'] = $data['total_sales'] - $data['total_hpp'];

                // Simpan data HPP historis (only if HPP data was found)
                if ($hppEffectiveDate) {
                    $hpp_historis = [
                        'partnumber' => $partnumber,
                        'periode' => date('Y-m', strtotime($start)), // Periode laporan
                        'hpp' => $data['total_hpp'],
                        'tanggal_hitung' => date('Y-m-d H:i:s'),
                        'hpp_effective_date' => $hppEffectiveDate->format('Y-m-d H:i:s'), // Store the effective date
                    ];

                    $entity = $this->HppHistoris->newEntity($hpp_historis);
                    $this->HppHistoris->save($entity);
                }


            $data['profit'] = $data['total_sales'] - $data['total_hpp'];
        }

            $totalProfitPart = array_sum(array_column($result, 'profit'));
            $totalProfitJasa = $pendapatanJasa['jasa'];
            $totalProfit = $totalProfitPart + $totalProfitJasa;

            $company = [
                'name' => 'AHASS RAJAWALI PUTERA',
                'address' => 'Alamat Perusahaan'
            ];

            switch ($this->request->getData('type')) {
                case 'html':
                    $file = 'html';
                    break;
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $periode = date("d F Y", strtotime($start)) . ' - ' . date("d F Y", strtotime($end));
            $this->set(compact('data', 'periode', 'company', 'result', 'totalProfitPart', 'totalProfitJasa', 'totalProfit'));
            $this->render($file);
        }

        $this->set(compact('data'));
    }
}