<?php
namespace Masters\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

class EmployeesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('mst_employes');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Jabatans', [
            'className'=>'Masters.Jabatans',
            'foreignKey' => 'jabatan_id'
        ]);



    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {

        $validator
            ->scalar('nama_mekanik')
            ->maxLength('nama_mekanik', 45)
            ->requirePresence('nama_mekanik', 'create')

            ->allowEmptyString('nama_mekanik', 'Nama mekanik harus diisi', false)
            ;

        $validator
            ->scalar('jabatan_id')
            ->maxLength('jabatan_id', 36)
            ->requirePresence('jabatan_id', 'create')
            ->allowEmptyString('jabatan_id', 'Jabatan harus diisi', false);

        return $validator;
    }


}
