<?php
namespace Masters\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Customers Model
 *
 * @property \MasterFile\Model\Table\GroupCustomersTable|\Cake\ORM\Association\BelongsTo $GroupCustomers
 * @property \MasterFile\Model\Table\BranchesTable|\Cake\ORM\Association\BelongsTo $Branches
 * @property \MasterFile\Model\Table\CitiesTable|\Cake\ORM\Association\BelongsTo $Cities
 * @property \MasterFile\Model\Table\ProvincesTable|\Cake\ORM\Association\BelongsTo $Provinces
 * @property \MasterFile\Model\Table\TopCustomersTable|\Cake\ORM\Association\BelongsTo $TopCustomers
 *
 * @method \MasterFile\Model\Entity\Customer get($primaryKey, $options = [])
 * @method \MasterFile\Model\Entity\Customer newEntity($data = null, array $options = [])
 * @method \MasterFile\Model\Entity\Customer[] newEntities(array $data, array $options = [])
 * @method \MasterFile\Model\Entity\Customer|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \MasterFile\Model\Entity\Customer patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \MasterFile\Model\Entity\Customer[] patchEntities($entities, array $data, array $options = [])
 * @method \MasterFile\Model\Entity\Customer findOrCreate($search, callable $callback = null, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class CustomersTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('mst_customers');

        $this->addBehavior('Timestamp');




    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {

        $validator
            ->scalar('nopol')
            ->requirePresence('nopol', 'create')
            ->allowEmptyString('nopol', 'Nomor polisi harus diisi', false)
            ->add('nopol', 'unique', [
                'rule' => 'validateUnique',
                'provider' => 'table',
                'message' => 'Nomor polisi sudah diinputkan',
                'on' => 'create', // Apply the rule only on create
            ]);
       ;


        return $validator;
    }


}
