<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/**
 * Customers Controller
 *
 * @property \Masters\Model\Table\CustomersTable $Customers
 *
 * @method \Masters\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class WarehousesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Gudang';
        $data['titleMenu'] = 'Master Gudang';

        $query = $this->Warehouses->find('all');
        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'kode_gudang LIKE' => '%' . $search . '%',
                    'nama_gudang LIKE' => '%' . $search . '%',
                    'branch_code LIKE' => '%' . $search . '%',
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Warehouses.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Warehouses.created desc');
        
        $warehouses = $this->paginate($query);


		

		//dd($getCookieCust);
		$this->set(compact('warehouses','data'));
		$this->set('_serialize', ['warehouses']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $data['titlePage'] = 'Master Gudang';
        $data['titleMenu'] = 'Data Gudang';
        $part = $this->Parts->get($id);

        $this->set(compact('warehouse','data' ));
        $this->set('_serialize', ['warehouse']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Gudang';
        $data['titleMenu'] = 'Data Gudang';
        $warehouse = $this->Warehouses->newEmptyEntity();
        if ($this->request->is('post')) {
            $warehouse = $this->Warehouses->patchEntity($warehouse, $this->request->getData());
            if ($this->Warehouses->save($warehouse)) {
                $this->Flash->success(__('The warehouse has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The warehouse could not be saved. Please, try again.'));
        }
        $this->set(compact('warehouse','data'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Gudang';
        $data['titleMenu'] = 'Data Gudang';
        $warehouse = $this->Warehouses->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $warehouse = $this->Warehouses->patchEntity($warehouse, $this->request->getData());
            
            $warehouse->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Warehouses->save($warehouse)) {
                $setStatus = 1;
                $message = 'The warehouse has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The warehouse could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }
        
        $this->set(compact('warehouse','data'));
        $this->set('_serialize', ['customer']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $data = $this->Warehouses->get($id);
        if ($this->Warehouses->delete($data)) {
            $this->Flash->success(__('The customer has been deleted.'));
        } else {
            $this->Flash->error(__('The customer could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    function searchTypeMtr(){
        $this->viewBuilder()->setLayout(false);
        $this->loadModel('MasterFile.Motorcyles');
        $keyword = $_GET['search'];
        $getTypeMtr = $this->Motorcyles->find()->where([" type_mtr like '%".$keyword."%'",'status'=>'Y'])->select(['motor_code','type_mtr'])->all();
        foreach ($getTypeMtr as $i => $v) {
            $data[] = array('id'=>$v->motor_code,'text'=>$v->type_mtr);
        }
        $result = json_encode($data);
        $this->response->type('json');
        $this->response->body($result);
        return $this->response    ;
    }

}
