<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/*use Cake\Http\Response;
use Cake\Utility\Security;
use Cake\Event\EventInterface;*/
use Cake\Log\Log;

class PartsController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();
    }

    public function index()
    {
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Data Part';

        $query = $this->Parts->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'partnumber LIKE' => '%' . $search . '%',
                    'deskripsi LIKE' => '%' . $search . '%',
                    'kel_barang LIKE' => '%' . $search . '%',
                    'harga' => $search,
                ]
            ]);
        }

        if ($this->request->getQuery('sort') && $this->request->getQuery('direction')) {
            $query = $query->order('Parts.' . $this->request->getQuery('sort') . ' ' . $this->request->getQuery('direction'));
        } else {
            $query = $query->order('Parts.created desc');
        }

        $parts = $this->paginate($query);

        $this->set(compact('parts', 'data'));
        $this->set('_serialize', ['parts']);
    }

    public function view($id = null)
    {
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Data Part';
        $part = $this->Parts->get($id);

        $this->set(compact('part', 'data'));
        $this->set('_serialize', ['part']);
    }

 public function add()
{
    $data['titlePage'] = 'Master Part';
    $data['titleMenu'] = 'Data Part';
    $part = $this->Parts->newEmptyEntity();
    if ($this->request->is('post')) {
        debug($this->request->getData());
        
        $part = $this->Parts->patchEntity($part, $this->request->getData());
        if ($this->Parts->save($part)) {
            $this->Flash->success(__('The Parts has been saved.'));

            return $this->redirect(['action' => 'index']);
        }
        $this->Flash->error(__('The Parts could not be saved. Please, try again.'));
    }
    $this->set(compact('part', 'data'));
}

public function edit($id = null)
{
    $this->loadComponent('General');
    $part = $this->Parts->find()->where(['id' => $id])->first();
    if ($this->request->is(['patch', 'post', 'put'])) {
        $connection = ConnectionManager::get('default');
        $connection->begin();
        try {
            $part = $this->Parts->patchEntity($part, $this->request->getData());
            $part->create_by = $this->getRequest()->getSession()->read('Auth.User.id');
            $part->modi_by = $this->getRequest()->getSession()->read('Auth.User.id');
            $part->harga = $this->General->__sinchronizecurrency($part->harga);
            $part->harga_beli = $this->General->__sinchronizecurrency($part->harga_beli);
            
            Log::write('debug', 'Entity after patch: ' . json_encode($part));
            
            if ($this->Parts->save($part)) {
                Log::write('debug', 'Part saved successfully');

                // Panggil fungsi updateHargaBeli setelah harga beli diubah
                $this->updateHargaBeli($part->partnumber, $part->harga_beli);

                $setStatus = 1;
                $message = 'The part has been saved.';
            } else {
                Log::write('debug', 'Failed to save part');
                $setStatus = 0;
                $message = 'The part could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if ($setStatus) {
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            } else {
                $connection->rollback();
            }
        } catch (\Exception $e) {
            Log::write('error', 'Error saving part: ' . $e->getMessage());
            $this->Flash->error(__('An error occurred: ' . $e->getMessage()));
            $connection->rollback();
        }
    }

    $this->set(compact('part'));
    $this->set('_serialize', ['part']);
}

    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $part = $this->Parts->get($id);
        if ($this->Parts->delete($part)) {
            $this->Flash->success(__('The Parts has been deleted.'));
        } else {
            $this->Flash->error(__('The Parts could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

   public function updateHargaBeli($partnumber, $newHargaBeli) {
    $conn = ConnectionManager::get('default');

    // 1. Tutup harga lama
    $conn->execute("
        UPDATE part_price_history
        SET valid_to = NOW()
        WHERE partnumber = :partnumber AND valid_to IS NULL", 
        ['partnumber' => $partnumber]
    );

    // 2. Tambahkan harga baru
    $conn->execute("
        INSERT INTO part_price_history (partnumber, harga_beli, valid_from, source)
        VALUES (:partnumber, :harga_beli, NOW(), 'mst_parts')", 
        ['partnumber' => $partnumber, 'harga_beli' => $newHargaBeli]
    );

    // 3. Update harga beli di mst_parts (opsional, jika diperlukan)
    $conn->execute("
        UPDATE mst_parts
        SET harga_beli = :harga_beli
        WHERE partnumber = :partnumber", 
        ['partnumber' => $partnumber, 'harga_beli' => $newHargaBeli]
    );
}

    public function inlineEdit()
{
    $this->autoRender = false; // Nonaktifkan rendering view
    $this->request->allowMethod(['post']); // Hanya izinkan metode POST

    // Ambil koneksi database
    $connection = ConnectionManager::get('default');

    try {
        // Mulai transaksi
        $connection->begin();

        // Ambil data dari request
        $data = $this->request->getData();
        $id = $data['id'];
        $field = $data['field'];
        $value = $data['value'];

        // Validasi field yang diizinkan - tambahkan deskripsi
        $allowedFields = ['harga', 'harga_beli', 'deskripsi'];
        if (!in_array($field, $allowedFields)) {
            throw new \Exception('Invalid field');
        }

        // Ambil data part dari database
        $part = $this->Parts->get($id);

        // Update field
        $part->$field = $value;

        // Simpan perubahan
        if ($this->Parts->save($part)) {
            // Panggil fungsi updateHargaBeli setelah harga beli diubah
            if ($field === 'harga_beli') {
                $this->updateHargaBeli($part->partnumber, $part->harga_beli);
            }

            $setStatus = 1;
            $message = 'The part has been saved.';
        } else {
            Log::write('debug', 'Failed to save part');
            $setStatus = 0;
            $message = 'The part could not be saved. Please, try again.';
        }

        // Set flash message
        $this->Flash->set(__($message));

        // Commit atau rollback transaksi
        if ($setStatus) {
            $connection->commit();
            echo json_encode(['success' => true, 'message' => $message]);
        } else {
            $connection->rollback();
            echo json_encode(['success' => false, 'message' => $message]);
        }
    } catch (\Exception $e) {
        // Log error dan rollback transaksi
        Log::write('error', 'Error saving part: ' . $e->getMessage());
        $this->Flash->error(__('An error occurred: ' . $e->getMessage()));
        $connection->rollback();
        echo json_encode(['success' => false, 'message' => 'An error occurred: ' . $e->getMessage()]);
    }
}

    public function getSparepart($partnumber)
    {
        $parttable = $this->fetchTable('Masters.Parts');
        $getParts = $parttable->find()->where(['partnumber' => $partnumber])
            ->first();
        echo json_encode($getParts);
        exit;
    }

    public function getpartdetail()
    {
        $this->viewBuilder()->setLayout(false);
        $keyword = $_GET['term'];
        $getpartnumber = $this->fetchTable('Masters.Parts')->find()->where([" partnumber like '%" . $keyword . "%'"])->select(['partnumber', 'partnumber'])->all();
        foreach ($getpartnumber as $i => $v) {
            $data[] = array('id' => $v->partnumber, 'text' => $v->partnumber);
        }
        echo json_encode($data);
        exit;
    }

    public function upload()
    {
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Tpload';
        $parttable = $this->fetchTable('Masters.Parts');
        $sparepart = $parttable->newEmptyEntity();
        $setStatus = 1;
        $message = 'The data has been saved.';
        if ($this->request->is('post')) {
            $connection = ConnectionManager::get('default');
            $connection->begin();

            $uploadedFile = $this->request->getData('files');
            $tempPath = $uploadedFile->getStream()->getMetadata('uri');

            $handle = fopen($tempPath, "r");

            $contents = [];
            while (!feof($handle)) {
                $line = fgets($handle);
                $temps = explode(";", $line);
                if ($temps[0] != '') {
                    $getPart = $parttable->find()->where(['partnumber' => $temps[0]])->first();
                    if ($getPart) {
                        $getPart->harga = $temps[2];
                        $getPart->kel_barang = $temps[5];
                        if (!$parttable->save($getPart)) {
                            $setStatus = 0;
                            $message = 'Fail update part (row ' . $temps[0] . '). Please, try again.';
                            break;
                        }
                    } else {
                        $mstStock['partnumber'] = $temps[0];
                        $mstStock['deskripsi'] = $temps[1];
                        $mstStock['harga'] = $temps[2];
                        $mstStock['kel_barang'] = $temps[5];
                        $mstStock['status'] = $temps[7];

                        $mstStock['created'] = date('Y-m-d H:i:s');;
                        $mstStock['create_by'] = $this->getRequest()->getSession()->read('Auth.id');
                        $mstStock['modified'] = date('Y-m-d H:i:s');
                        $mstStock['modi_by'] = $this->getRequest()->getSession()->read('Auth.id');

                        $parts = $parttable->newEmptyEntity();
                        $parts = $parttable->patchEntity($parts, $mstStock);
                        if (!$parttable->save($parts)) {
                            $setStatus = 0;
                            $message = 'Fail insert part (row ' . ($i + 1) . '). Please, try again.';
                            break;
                        } else {
                            $setStatus = 1;
                            $message = 'The data has been saved.';
                        }
                    }
                }
            }

            $this->Flash->set(__($message));

            if ($setStatus) {
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            } else {
                $connection->rollback();
            }
        }
        $this->set(compact('sparepart', 'data'));
        $this->set('_serialize', ['sparepart']);
    }
    
   public function ajaxGetData()
{
    $this->request->allowMethod(['get']);
    $data = $this->paginate('Masters.Parts');

    $response = new Response();
    $response = $response->withStringBody(json_encode($data))
        ->withType('application/json')
        ->withHeader('Access-Control-Allow-Origin', '*');

    return $response;
}
}