<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;

class JasasController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Jasa';
        $data['titleMenu'] = 'Data Jasa';


        $query = $this->Jasas->find('all');
        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'kode_jasa LIKE' => '%' . $search . '%',
                    'nama_jasa LIKE' => '%' . $search . '%',
                    'type_jasa LIKE' => '%' . $search . '%',
                    'harga' => $search,
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Jasas.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Jasas.created desc');
        
        $jasas = $this->paginate($query);

        
       
        
      //  $opJasa=['KPB1'=>'KPB1','KPB2'=>'KPB2','KPB3'=>'KPB3','KPB4'=>'KPB4', //'CS'=>'CS','QS'=> 'QS', 'LR'=>'LR', 'HR'=>'HR'];
        
      
      $this->set(compact('jasas','data'));
      $this->set('_serialize', ['jasas']);
    }
    
    
    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $jasa = $this->Jasas->get($id);

        $this->set('jasa', $jasa);
        $this->set('_serialize', ['jasa']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Jasa';
        $data['titleMenu'] = 'Data Jasa';
        //$this->loadComponent('General');
        //$setStatus = Y;
        $jasa = $this->Jasas->newEmptyEntity();
        if ($this->request->is('post')) {

            $connection = ConnectionManager::get('default');
            $connection->begin();
            $jasa = $this->Jasas->patchEntity($jasa, $this->request->getData());
            $jasa->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $jasa->modi_by = $this->getRequest()->getSession()->read('Auth.id');

            if ($this->Jasas->save($jasa)) {
                $setStatus = 1;
                $message = 'The data has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }


        $this->set(compact('jasa','data'));
        $this->set('_serialize', ['jasa']);
    }


    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Jasa';
        $data['titleMenu'] = 'Data Jasa';
        $jasa = $this->Jasas->get($id);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $jasa = $this->Jasas->patchEntity($jasa, $this->request->getData());
            $jasa->modi_by = $this->getRequest()->getSession()->read('Auth.id');
			//dd($jasa);
            if ($this->Jasas->save($jasa)) {
                $setStatus = 1;
                $message = 'The jasa has been saved.';
            }else{
                dd($jasa)->errors();
                $setStatus = 0;
                $message = 'The jasa could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }
        $opJasa=['KPB1'=>'KPB1','KPB2'=>'KPB2','KPB3'=>'KPB3','KPB4'=>'KPB4', 'CS'=>'CS','QS'=> 'QS', 'LR'=>'LR', 'HR'=>'HR'];    
        $this->set(compact('jasa','opJasa','data'));
        $this->set('_serialize', ['jasa','opJasa']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function delete($id = null)
     {
         $this->request->allowMethod(['post', 'delete']);
         $connection = ConnectionManager::get('default');
         $connection->begin();
         if(isset($this->request->data['id'])){
             $ids = explode(',',$this->request->data['id']);
         }else $ids = $id;

         foreach($ids as $i=>$v){
           $jasa = $this->Jasas->get($v);
           if ($this->Jasas->delete($jasa,[
             'dependent' => true,
             'cascadeCallbacks' => true
             ])) {
               $setStatus=1;
               $message = 'The jasa has been deleted.';
           } else {
               $setStatus=0;
               $message = 'The jasa with id: '.$v.' could not be deleted. Please, try again.';
               break;
           }
         }

         $this->Flash->error(__($message));
         if($setStatus){
             $connection->commit();
         }else {
             $connection->rollback();
         }
         return $this->redirect(['action' => 'index']);
     }
}
