<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Core\Configure;
use Cake\Http\ServerRequest;
use Cake\ORM\TableRegistry;
/**
 * Customers Controller
 *
 * @property \Masters\Model\Table\CustomersTable $Customers
 *
 * @method \Masters\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class CustomersController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Konsumen';
        $data['titleMenu'] = 'Data Konsumen';


        $query = $this->Customers->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'nopol LIKE' => '%' . $search . '%',
                    'nosin LIKE' => '%' . $search . '%',
                    'nama LIKE' => '%' . $search . '%',
                    'no_tlp' => $search,
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Customers.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Customers.created desc');
        
        $customers = $this->paginate($query);

		//dd($getCookieCust);
		$this->set(compact('customers','data'));
		$this->set('_serialize', ['customers']);
    }

    public function ajaxData()
    {
        $this->disableAutoRender();
        $this->viewBuilder()->setClassName('Json'); // Set JSON response

        $request = $this->request;
        $draw = $request->getData('draw'); // Get draw number for data consistency

        // Filtering (optional, adjust based on DataTables parameters)
        $searchValue = $request->getData("search['value']");
//dd( $request->getData("search['value']"));
        $custTable = $this->fetchTable('Masters.Customers');
        $query = $this->Customers->find()->select(['nopol','nama','alamat']);
       // if ($searchValue) {
            $query->where([
                'OR' => [
                    'Customers.nopol LIKE' => '%' . $searchValue . '%'
                ]
            ]);
       // }

        // Ordering (optional, adjust based on DataTables parameters)
        $order = $request->getData('order');
        // if ($order) {
        //     $column = $order[0]['column']; // Get the order column index

        //     $dir = $order[0]['dir']; // Get the order direction (asc or desc)
        //     $query->order([$custTable->aliasField($column) => $dir]);
        // }

        // Length, Start, and Additional Conditions (optional)
        $length = $request->getData('length'); // Get the number of records to fetch
        $start = $request->getData('start'); // Get the starting index for pagination
        $query->limit($length)->offset($start);

        // Fetch data and total records
        $recordsTotal = $query->count();
        $recordsData = $query->toArray();
        //dd($request);
        // Prepare JSON response
        $data = [
            'draw' => $draw,
            'recordsTotal' => $recordsTotal,
            'recordsFiltered' => $recordsTotal, // Assume filtering fetches all records
            'data' => $recordsData,
        ];
        echo json_encode($data);

    //    $this->setResponse([
    //     'body' => json_encode($data),
    //     'headers' => [
    //         'Content-Type' => 'application/json',
    //     ],
    // ]);



    }


    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $data['titlePage'] = 'Master Konsumen';
        $data['titleMenu'] = 'Data Konsumen';
        $customer = $this->Customers->get($id);

        $this->set(compact('customer','data' ));
        $this->set('_serialize', ['customer']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Konsumen';
        $data['titleMenu'] = 'Data Konsumen';
        $customer = $this->Customers->newEmptyEntity();
        $this->loadComponent('General');
        if ($this->request->is('post')) {
            $customer = $this->Customers->patchEntity($customer, $this->request->getData());
            $customer->customer_code=$this->General->__sinchronizeID('C',date('ym'),4,array('val_id','val_char', 'val_value'));
            if ($this->Customers->save($customer)) {
                $this->Flash->success(__('The customer has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The customer could not be saved. Please, try again.'));
        }
        $CorporateTable = $this->fetchTable('Masters.Corporates');
        $corporates = $CorporateTable
                    ->find('list',
                        keyField : 'id',
                        valueField : 'name'
                    )
                    ->toArray();
        
        $this->set(compact('customer','data','corporates'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Konsumen';
        $data['titleMenu'] = 'Data Konsumen';
        $customer = $this->Customers->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $customer = $this->Customers->patchEntity($customer, $this->request->getData());
            $customer->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Customers->save($customer)) {
                $setStatus = 1;
                $message = 'The customer has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The customer could not be saved. Please, try again.';
            }

            $this->Flash->error(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }
        $CorporateTable = $this->fetchTable('Masters.Corporates');
        $corporates = $CorporateTable
                    ->find('list',
                        keyField : 'id',
                        valueField : 'name'
                    )
                    ->toArray();
       
        //dd($getTypeMtr);
        $this->set(compact('customer','data','corporates'));
        $this->set('_serialize', ['customer']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $customer = $this->Customers->get($id);
        if ($this->Customers->delete($customer)) {
            $this->Flash->success(__('The customer has been deleted.'));
        } else {
            $this->Flash->error(__('The customer could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    function searchTypeMtr(){
        $this->viewBuilder()->setLayout(false);
        $this->loadModel('MasterFile.Motorcyles');
        $keyword = $_GET['search'];
        $getTypeMtr = $this->Motorcyles->find()->where([" type_mtr like '%".$keyword."%'",'status'=>'Y'])->select(['motor_code','type_mtr'])->all();
        foreach ($getTypeMtr as $i => $v) {
            $data[] = array('id'=>$v->motor_code,'text'=>$v->type_mtr);
        }
        $result = json_encode($data);
        $this->response->type('json');
        $this->response->body($result);
        return $this->response    ;
    }

}
