<?php
namespace MasterFile\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/**
 * Spareparts Controller
 *
 * @property \MasterFile\Model\Table\CustomersTable $Spareparts
 *
 * @method \MasterFile\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class SparepartsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {

      $query  = $this->Spareparts->find();
      if ($this->request->is('put')) {
            $cond = $this->__FilterSearch($this->request->data['filter']);
            $this->request->session()->write('Auth.Filter.Keyword',$cond);
      }
      $kondisi = $this->request->session()->read('Auth.Filter.Keyword');
      //dd($kondisi);
      if($kondisi){
        foreach($kondisi as $v){
          $query = $query->where( $v['conditions'][0] );
          foreach($v['bind'] as $j){
            $query=$query->bind($j[0],$j[1]);
          }
        }
      }
      if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
        $query = $query->order('Spareparts.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
      }else $query = $query->order('Spareparts.created desc');
      
      
      $spareparts = $this->paginate($query);
      $this->set(compact('spareparts'));
      $this->set('_serialize', ['spareparts']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $sparepart = $this->Spareparts->get($id);

        $this->set('sparepart', $sparepart);
        $this->set('_serialize', ['sparepart']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $this->loadModel('MasterFile.MasterSpareparts')  ;
        $this->loadComponent('General');
        $setStatus = 1;
        $sparepart = $this->MasterSpareparts->newEntity();
        if ($this->request->is('post')) {

            $connection = ConnectionManager::get('default');
            $connection->begin();
            $sparepart = $this->MasterSpareparts->patchEntity($sparepart, $this->request->getData());
            
            $sparepart->create_by = $this->request->session()->read('Auth.User.id');
            $sparepart->modi_by = $this->request->session()->read('Auth.User.id');
            $sparepart->harga = $this->General->__sinchronizecurrency($sparepart->harga);
            if ($this->MasterSpareparts->save($sparepart)) {
                $setStatus = 1;
                $message = 'The sparepart has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The sparepart could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'add']);
            }else {
                $connection->rollback();
            }
        }

        
        $this->set(compact('sparepart'));
        $this->set('_serialize', ['sparepart']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $this->loadComponent('General');
        $this->loadModel('MasterFile.MasterSpareparts')  ;
        $sparepart = $this->MasterSpareparts->find()->where(['id'=>$id])->first();
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $sparepart = $this->MasterSpareparts->patchEntity($sparepart, $this->request->getData());
            $sparepart->create_by = $this->request->session()->read('Auth.User.id');
            $sparepart->modi_by = $this->request->session()->read('Auth.User.id');
            $sparepart->harga = $this->General->__sinchronizecurrency($sparepart->harga);
			//dd($sparepart);
            if ($this->MasterSpareparts->save($sparepart)) {
                $setStatus = 1;
                $message = 'The sparepart has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The sparepart could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }

        $this->set(compact('sparepart'));
        $this->set('_serialize', ['sparepart']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function delete($id = null)
     {
         $this->request->allowMethod(['post', 'delete']);
         $connection = ConnectionManager::get('default');
         $connection->begin();
         if(isset($this->request->data['id'])){
             $ids = explode(',',$this->request->data['id']);
         }else $ids = $id;

         foreach($ids as $i=>$v){
           $sparepart = $this->Spareparts->get($v);
           if ($this->Spareparts->delete($sparepart,[
             'dependent' => true,
             'cascadeCallbacks' => true
             ])) {
               $setStatus=1;
               $message = 'The sparepart has been deleted.';
           } else {
               $setStatus=0;
               $message = 'The sparepart with id: '.$v.' could not be deleted. Please, try again.';
               break;
           }
         }

         $this->Flash->error(__($message));
         if($setStatus){
             $connection->commit();
         }else {
             $connection->rollback();
         }
         return $this->redirect(['action' => 'index']);
     }

     function upload(){
        $this->loadModel('MasterFile.MasterSpareparts')  ;
        $sparepart = $this->MasterSpareparts->newEntity();
        $setStatus=1;
        $message = 'The data has been saved.';
        if($this->request->is('post')){
            $connection = ConnectionManager::get('default');
            $connection->begin();
            
            $handle = fopen($this->request->data['files']['tmp_name'], "r");
            $contents=explode("\n", fread($handle, filesize($this->request->data['files']['tmp_name'])));
            
            for ($i=0; $i<sizeof($contents); $i++){
                $temps = explode(";",$contents[$i]);
                //dd($temps);
                if($temps[0]){
                        $getPart = $this->MasterSpareparts->find()->where(['partnumber'=>$temps[0]])->first();
                        if($getPart){
                            $getPart->harga = $temps[2];
                            $getPart->kel_barang = $temps[5];
                             if(!$this->MasterSpareparts->save($getPart)){
                                $setStatus = 0;
                                $message = 'Fail update part (row '.($i+1).'). Please, try again.';
                                break;
                             }  
                        }else{
                            //insert partif
                                $mstStock['partnumber'] = $temps[0];
                                $mstStock['deskripsi'] = $temps[1];
                                $mstStock['harga'] = $temps[2];
                                $mstStock['kel_barang'] = $temps[5];
                                $mstStock['status'] = $temps[7];
                                
                                $mstStock['created'] = date('Y-m-d H:i:s');;
                                $mstStock['create_by'] = $this->request->session()->read('Auth.User.id');;
                                $mstStock['modified'] = date('Y-m-d H:i:s');
                                $mstStock['modi_by'] = $this->request->session()->read('Auth.User.id');;

                                $parts = $this->MasterSpareparts->newEntity($mstStock);
                                if(!$this->MasterSpareparts->save($parts)){
                                      $setStatus = 0;
                                      $message = 'Fail insert part (row '.($i+1).'). Please, try again.';
                                      break;
                                }else{
                                    $setStatus = 1;
                                    $message = 'The data has been saved.';
                                }
                        }
                
                 }       
               
            }   
           
            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }

        }
        $this->set(compact('sparepart'));
        $this->set('_serialize', ['sparepart']);
     }
}
