<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

$fileName = 'report-penjualan-part.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set document properties
$spreadsheet->getProperties()
    ->setCreator($company['name'])
    ->setTitle('Report Penjualan Part')
    ->setSubject('Profit Penjualan Part dan Jasa');

// Set the title and company information
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', $company['address']);
$sheet->setCellValue('A3', 'Periode: ' . $periode);
$sheet->mergeCells('A1:L1');
$sheet->mergeCells('A2:L2');
$sheet->mergeCells('A3:L3');

// Style for company header
$headerStyle = [
    'font' => [
        'bold' => true,
        'size' => 14
    ],
    'alignment' => [
        'horizontal' => Alignment::HORIZONTAL_CENTER,
    ]
];
$sheet->getStyle('A1:L3')->applyFromArray($headerStyle);

// Profit Per Mekanik Summary
$sheet->setCellValue('A5', 'Profit Per Mekanik');
$sheet->mergeCells('A5:L5');
$sheet->getStyle('A5')->getFont()->setBold(true);

// Set headers for profit per mekanik
$row = 6;
$mekanikHeaders = ['Nama Mekanik', 'Profit Part', 'Profit Jasa', 'Total Profit'];
$headerFill = [
    'fillType' => Fill::FILL_SOLID,
    'startColor' => ['argb' => 'FFD9D9D9']
];

foreach ($mekanikHeaders as $col => $header) {
    $sheet->setCellValueByColumnAndRow($col + 1, $row, $header);
    $sheet->getStyleByColumnAndRow($col + 1, $row)->applyFromArray([
        'font' => ['bold' => true],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER],
        'fill' => $headerFill,
        'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]]
    ]);
}

// Add profit per mekanik data
$row = 7;
foreach ($profitPerMekanik as $mekanik) {
    $sheet->setCellValue('A' . $row, $mekanik['nama_mekanik']);
    $sheet->setCellValue('B' . $row, $mekanik['profit_part']);
    $sheet->setCellValue('C' . $row, $mekanik['profit_jasa']);
    $sheet->setCellValue('D' . $row, $mekanik['total_profit']);
    
    // Format numbers to match HTML view (no decimals, thousand separators)
    $sheet->getStyle('B' . $row . ':D' . $row)->getNumberFormat()
          ->setFormatCode('#,##0;[Red]-#,##0');
    $sheet->getStyle('B' . $row . ':D' . $row)->getAlignment()
          ->setHorizontal(Alignment::HORIZONTAL_RIGHT);
    
    $sheet->getStyle('A' . $row . ':D' . $row)->applyFromArray([
        'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]]
    ]);
    
    $row++;
}

// Add totals for profit per mekanik
$sheet->setCellValue('A' . $row, 'Total');
$sheet->setCellValue('B' . $row, $totalProfitPart);
$sheet->setCellValue('C' . $row, $totalProfitJasa);
$sheet->setCellValue('D' . $row, $totalProfit);

$sheet->getStyle('A' . $row . ':D' . $row)->applyFromArray([
    'font' => ['bold' => true],
    'fill' => $headerFill,
    'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]]
]);
$sheet->getStyle('B' . $row . ':D' . $row)->getNumberFormat()
      ->setFormatCode('#,##0;[Red]-#,##0');
$sheet->getStyle('B' . $row . ':D' . $row)->getAlignment()
      ->setHorizontal(Alignment::HORIZONTAL_RIGHT);

// Detail Penjualan Part Header
$row += 2;
$sheet->setCellValue('A' . $row, 'Detail Penjualan Part');
$sheet->mergeCells('A' . $row . ':L' . $row);
$sheet->getStyle('A' . $row)->getFont()->setBold(true);

// Set the headers for detail part
$row++;
$headers = ['Tanggal', 'Kode Transaksi', 'Nopol', 'Mekanik', 'No Part', 'Nama Part', 'Qty', 'Harga', 'Diskon', 'Total Harga', 'Total HPP', 'Profit'];
$headerFill = [
    'fillType' => Fill::FILL_SOLID,
    'startColor' => ['argb' => 'FFD9D9D9']
];

foreach ($headers as $col => $header) {
    $sheet->setCellValueByColumnAndRow($col + 1, $row, $header);
    $sheet->getStyleByColumnAndRow($col + 1, $row)->applyFromArray([
        'font' => ['bold' => true],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER],
        'fill' => $headerFill,
        'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]]
    ]);
}

// Add the detail data
$row++;
$totalHarga = 0;
$totalHPP = 0;
$totalProfitPartDetail = 0;
foreach ($result as $i => $v) {
    $sheet->setCellValue('A' . $row, $v['trans_date']);
    $sheet->setCellValue('B' . $row, $v['kode_workshop']);
    $sheet->setCellValue('C' . $row, $v['nopol']);
    $sheet->setCellValue('D' . $row, $v['nama_mekanik']);
    $sheet->setCellValue('E' . $row, $v['partnumber']);
    $sheet->setCellValue('F' . $row, $v['partdesc']);
    $sheet->setCellValue('G' . $row, $v['total_qty']);
    $sheet->setCellValue('H' . $row, $v['price']);
    $sheet->setCellValue('I' . $row, $v['diskon']);
    $sheet->setCellValue('J' . $row, $v['total_harga']);
    $sheet->setCellValue('K' . $row, $v['total_hpp']);
    $sheet->setCellValue('L' . $row, $v['profit']);

    // Format number columns to match HTML view
    $numberColumns = ['H', 'I', 'J', 'K', 'L']; // Harga, Diskon, Total Harga, Total HPP, Profit
    foreach ($numberColumns as $col) {
        $sheet->getStyle($col . $row)->getNumberFormat()
              ->setFormatCode('#,##0;[Red]-#,##0');
        $sheet->getStyle($col . $row)->getAlignment()
              ->setHorizontal(Alignment::HORIZONTAL_RIGHT);
    }

    $sheet->getStyle('A' . $row . ':L' . $row)->applyFromArray([
        'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]]
    ]);

    $totalHarga += $v['total_harga'];
    $totalHPP += $v['total_hpp'];
    $totalProfitPartDetail += $v['profit'];
    $row++;
}

// Add the totals row for detail part
$sheet->setCellValue('I' . $row, 'Total');
$sheet->setCellValue('J' . $row, $totalHarga);
$sheet->setCellValue('K' . $row, $totalHPP);
$sheet->setCellValue('L' . $row, $totalProfitPartDetail);

$sheet->getStyle('I' . $row . ':L' . $row)->applyFromArray([
    'font' => ['bold' => true],
    'fill' => $headerFill,
    'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]]
]);
$sheet->getStyle('J' . $row . ':L' . $row)->getNumberFormat()
      ->setFormatCode('#,##0;[Red]-#,##0');
$sheet->getStyle('J' . $row . ':L' . $row)->getAlignment()
      ->setHorizontal(Alignment::HORIZONTAL_RIGHT);

// Set column widths
$sheet->getColumnDimension('A')->setWidth(15); // Tanggal
$sheet->getColumnDimension('B')->setWidth(15); // Kode Transaksi
$sheet->getColumnDimension('C')->setWidth(12); // Nopol
$sheet->getColumnDimension('D')->setWidth(20); // Mekanik
$sheet->getColumnDimension('E')->setWidth(15); // No Part
$sheet->getColumnDimension('F')->setWidth(30); // Nama Part
$sheet->getColumnDimension('G')->setWidth(8);  // Qty
$sheet->getColumnDimension('H')->setWidth(15); // Harga
$sheet->getColumnDimension('I')->setWidth(12); // Diskon
$sheet->getColumnDimension('J')->setWidth(15); // Total Harga
$sheet->getColumnDimension('K')->setWidth(15); // Total HPP
$sheet->getColumnDimension('L')->setWidth(15); // Profit

// Save the workbook to a file
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
$writer->save('php://output');
exit;
?>