<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPerformanceMekaniksController extends AppController
{

    public $PhpExcel = null;

    public function index()
    {

     $conn = ConnectionManager::get('default');
     $data['titlePage'] = 'Report Performance Mekanik';
     $data['titleMenu'] = 'Report Performance Mekanik';
      if ($this->request->is('post')) { 
         	
		  $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
		  $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
		 
		 $start = $this->request->getData('start');
		 $end = $this->request->getData('end');
		 
		  $result =$conn->execute(" SELECT a.mekanik, a.nama_mekanik, SUM(CASE WHEN c.kode_jasa='GO' THEN 1 ELSE 0 END) GO, 
		                            SUM(CASE WHEN c.kode_jasa='CS' THEN 1 ELSE 0 END) CS, 
		                            SUM(CASE WHEN c.kode_jasa LIKE'KPB1%' THEN 1 ELSE 0 END) KPB1, 
		                            SUM(CASE WHEN c.kode_jasa LIKE'KPB2%' THEN 1 ELSE 0 END) KPB2, 
		                            SUM(CASE WHEN c.kode_jasa LIKE'KPB3%' THEN 1 ELSE 0 END) KPB3, 
		                            SUM(CASE WHEN c.kode_jasa LIKE'KPB4%' THEN 1 ELSE 0 END) KPB4, 
		                            SUM(CASE WHEN c.kode_jasa LIKE 'SL%' THEN 1 ELSE 0 END) SL, 
		                            SUM(CASE WHEN c.kode_jasa LIKE 'SR%' THEN 1 ELSE 0 END) SR,
		                            COUNT(c.kode_jasa) TOTAL
		                            FROM workshops a LEFT JOIN  workshops_dtlservices c ON(a.id=c.workshop_id) 
		                            WHERE a.trans_date >= '".$start."' AND a.trans_date <= '".$end."'  
                                    GROUP BY a.mekanik
                                    ORDER BY a.nama_mekanik ASC;
		                           ");
		  $result = $result->fetchAll('assoc');  
		//  pr($result); 
		  
		  if(empty($result)){
				$this->Flash->set(__('Data tidak tersedia.'));
				return $this->redirect(['action' => 'index']);
			}
          switch ($this->request->getData('type')) {
            case 'html':
              $file = 'html';
              break;
            case 'excel':
              $file = 'excel';
              break;
            case 'pdf':
              $file = 'pdf';
              break;
            default:
              $file = 'html';
              break;
          }
		  		$periode = date("d F Y",strtotime($this->request->getData('start'))).' - '.date("d F Y",strtotime($this->request->getData('end')));
          $this->set(compact('data','periode','company','result'));
          $this->render($file);
        }
         $this->set(compact('data'));
    }

}
