function addRowpart(base) {
    // Increment the counter
    var nextCounter = Number($('#tr_d_counter_stock_opname_details').val()) + 1;
    
    // Construct the new row HTML using template literals for better readability
    var html = `
    <tr class="active" id="tr_stock_opname_details_${nextCounter}" row="${nextCounter}">
      <td width="250">
        <div class="input text">
          <input type="text" name="stock_opname_details[${nextCounter}][partnumber]" 
                 class="selectpart form-control" 
                 row="${nextCounter}" 
                 id="stock-opname-details-${nextCounter}-partnumber" 
                 onchange="searchpart(this.id, '${base}')">
        </div>
      </td>
      <td>
        <div class="input text">
          <input type="text" name="stock_opname_details[${nextCounter}][partdesc]" 
                 class="form-control" 
                 row="${nextCounter}" 
                 id="stock-opname-details-${nextCounter}-partdesc">
        </div>
      </td>
      <td>
        <div class="input select">
          <select name="stock_opname_details[${nextCounter}][rak_code]" 
                  id="stock-opname-details-${nextCounter}-rak-code" 
                  row="${nextCounter}" 
                  onchange="getQtyAvail(this.id)" 
                  class="form-control">
            <option value="">pilih rak</option>
          </select>
        </div>
      </td>
      <td width="100">
        <div class="input text">
          <input type="text" name="stock_opname_details[${nextCounter}][qty_avail]" 
                 class="form-control currency" 
                 row="${nextCounter}" 
                 id="stock-opname-details-${nextCounter}-qty-avail" 
                 readonly>
        </div>
      </td>
      <td width="100">
        <div class="input text">
          <input type="text" name="stock_opname_details[${nextCounter}][qty1]" 
                 class="form-control currency" 
                 row="${nextCounter}" 
                 id="stock-opname-details-${nextCounter}-qty1" 
                 onchange="getQty(this.id)">
        </div>
      </td>
      <td width="100">
        <div class="input text">
          <input type="text" name="stock_opname_details[${nextCounter}][qty_delta]" 
                 class="form-control currency" 
                 row="${nextCounter}" 
                 id="stock-opname-details-${nextCounter}-qty-delta" 
                 readonly>
        </div>
      </td>
      <td>
        <input type="button" id="delrowstock_opname_details${nextCounter}" 
               class="btn btn-danger btn-sm" 
               value="-" 
               rel="tr_stock_opname_details_${nextCounter}" 
               onclick="deleteRow(this.id)" 
               row="${nextCounter}">
      </td>
    </tr>`;

    // Add the new row to the table before the hidden row
    $('#trhidden_d_counter_stock_opname_details').before(html);
    
    // Update the counter
    $('#tr_d_counter_stock_opname_details').val(nextCounter);
    
    // Initialize the select part for the newly added row
    initSelectPart('.selectpart');
}


function deleteRow(id){
    var row = $("#"+id).attr('row');
    $("#tr_stock_opname_details_"+row).remove();
} 
function searchpart(id,url){
   
    var val = $("#"+id).val();
    var row = $("#"+id).attr('row');
    var url = url;
    var nextRow = Number(row )+1;
    $.getJSON(url+'/'+val,function(data){
        if(data){
          var getDuplicateId = checkDuplicate3();
          if(getDuplicateId){
               
                $("#invoice-parts-"+row+"-partnumber").focus();  
                $("#invoice-parts-"+row+"-partnumber").val('');  
          }else{
                console.log(row);
                $("#stock-opname-details-"+row+"-partdesc").val(data.deskripsi);
                getRak(data.partnumber,row);
                // initSelectPart('.partnumber');
                 $("#stock-opname-details-"+nextRow+"-partnumber").focus();  
          }
              
              
         

        }else{
            $("#invoice-parts-"+row+"-partnumber").focus();  
            $("#invoice-parts-"+row+"-partnumber").val('');  
            alert('Maaf, partnumber tidak ditemukan');
        }
      });
}

function checkDuplicate3() {
    var inputs = document.querySelectorAll('.selectpart');
    var values = Array.from(inputs).map(input => input.value.trim());
    var duplicateIds = [];
    var existingIds = [];

    inputs.forEach(input => {
        existingIds.push(input.id);
    });

    values.forEach((value, index) => {
        if (values.indexOf(value) !== index && !duplicateIds.includes(existingIds[index])) {
            duplicateIds.push(existingIds[values.indexOf(value)]);
            console.log(index);
            console.log(values.indexOf(value));
        }
    });

    
    return  duplicateIds.join(', ');
}