<?php
namespace UserPriviledges\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Groups Model
 *
 * @property \UserPriviledges\Model\Table\UsersTable|\Cake\ORM\Association\BelongsToMany $Users
 *
 * @method \UserPriviledges\Model\Entity\Group get($primaryKey, $options = [])
 * @method \UserPriviledges\Model\Entity\Group newEntity($data = null, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group[] newEntities(array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \UserPriviledges\Model\Entity\Group patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group[] patchEntities($entities, array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\Group findOrCreate($search, callable $callback = null, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class GroupsMenusTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('groups_menus');
        $this->setPrimaryKey('id');
        $this->belongsTo('SystemConfigurations.Menus');
        $this->belongsTo('UserPriviledges.Groups');
    }

    public function parentNode() {
        return null;
    }

}
