<?php
declare(strict_types=1);

namespace Transactions\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;


class PettyCashTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('petty_cash');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp');
    }


    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {

        $validator
            ->scalar('name')
            ->requirePresence('name', 'create')
            ->allowEmptyString('name', 'Nama harus diisi', false)    
       ;
       $validator
            ->scalar('description')
            ->requirePresence('description', 'create')
            ->allowEmptyString('description', 'Keterangan harus diisi', false)    
       ;

       $validator
            ->scalar('amount')
            ->requirePresence('amount', 'create')
            ->allowEmptyString('amount', 'Nilai harus diisi', false)    
       ;


        return $validator;
    }

}
