<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;

class PettyCashController extends AppController
{
    var $tipeTrans = ['K'=>'Pengeluaran Kas','O'=>'Other'];
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
        
       
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Pengeluaran Kas';
        $data['titleMenu'] = 'Pengeluaran Kas';

        $query = $this->PettyCash->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'trx_no LIKE' => '%' . $search . '%',
                    'name LIKE' => '%' . $search . '%',
                    'trx_type LIKE' => '%' . $search . '%',
                    'trx_date' => $search,
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('PettyCash.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('PettyCash.created desc');
        
        $pettycash = $this->paginate($query);

        $tipeTrans = $this->tipeTrans;
      
        $this->set(compact('data','pettycash','tipeTrans'));
    }
    public function add(){
        $data['titlePage'] = 'Kas Kecil';
        $data['titleMenu'] = 'Add Data Kas Kecil';
        $this->loadComponent('General');
        $setStatus = 1;
        $pettycash = $this->PettyCash->newEmptyEntity();
        if ($this->request->is('post')) {
            //dd($pettycash);
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $pettycash = $this->PettyCash->patchEntity($pettycash, $this->request->getData());
            $pettycash->trx_no=$this->General->__sinchronizeID('KK',date('ym'),5,array('val_id','val_char', 'val_value'));
            $pettycash->amount = $this->General->__sinchronizecurrency($pettycash->amount);
            $pettycash->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $pettycash->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->PettyCash->save($pettycash)) {
                
                $message='The data has been saved.';
            }else{
                $setStatus=0;
                $message='The data could not be saved. Please, try again.';
            }
           
            
            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }


        }

        

        $tipeTrans = $this->tipeTrans;
                            
        $this->set(compact('pettycash','data','tipeTrans'));
        $this->set('_serialize', ['pettycash']);            
    }
    
    public function edit($id){
        $data['titlePage'] = 'Kas Kecil';
        $data['titleMenu'] = 'Add Data Kas Kecil';
        $this->loadComponent('General');
        $setStatus = 1;
        $pettycash = $this->PettyCash->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            //dd($pettycash);
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $pettycash = $this->PettyCash->patchEntity($pettycash, $this->request->getData());
           
            $pettycash->amount = $this->General->__sinchronizecurrency($pettycash->amount);
            $pettycash->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $pettycash->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->PettyCash->save($pettycash)) {
                
                $message='The data has been saved.';
            }else{
                $setStatus=0;
                $message='The data could not be saved. Please, try again.';
            }
           
            
            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }


        }

        

        $tipeTrans = $this->tipeTrans;
                            
        $this->set(compact('pettycash','data','tipeTrans'));
        $this->set('_serialize', ['pettycash']);            
    }

    public function view($id = null)
    {
        $data['titlePage'] = 'Kas Kecil';
        $data['titleMenu'] = 'Kas Kecil';
        $pettycash = $this->PettyCash->get($id);
        $tipeTrans = $this->tipeTrans;
        $this->set(compact('data','pettycash','tipeTrans'));
    }

    public function prints($id = null)
    {
        $CompaniesTable = $this->fetchTable('SystemConfigurations.Companies');
        $companies = $CompaniesTable->find()->first();
        $this->viewBuilder()->setLayout('print');
        $data['titlePage'] = 'Kas Kecil';
        $data['titleMenu'] = 'Kas Kecil';
        $pettycash = $this->PettyCash->get($id);
        $tipeTrans = $this->tipeTrans;
        $this->set(compact('data','pettycash','tipeTrans','companies'));
    }
}
