<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?=$this->Html->link('Home', ['plugin' => 'SystemConfigurations', 'controller' => 'home', 'action' => 'index'])?></li>
                <li class="breadcrumb-item"><?=$this->Html->link('Report', ['plugin' => 'Reports', 'controller' => 'ReportCustomerService', 'action' => 'index'])?></li>
                <li class="breadcrumb-item"><?=$this->Html->link('Profit', ['plugin' => 'Reports', 'controller' => 'ReportProfits', 'action' => 'index'])?></li>
                <li class="breadcrumb-item active">Index</li>
            </ol>
        </div>
        <!-- row -->
        <?php if($this->getRequest()->getSession()->read('Flash')){?>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="alert alert-danger alert-dismissible fade show mb-3"><?= $this->Flash->render() ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></div>
                </div>
            </div>
        <?php } ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row col-lg-12">
                            <div class="col-md-6 col-lg-6">
                                <h4 class="card-title"><?=$company['name']?></h4>
                                <p><strong>Periode :</strong> <?=$periode?></p>
                                <p><strong>Metode HPP yang Digunakan:</strong> Average Cost</p>
                                <p><strong>Rumus HPP:</strong> Total HPP = Rata-rata Harga Barang × Jumlah Barang</p>
                                <p><strong>Rumus Profit:</strong> Profit = Pendapatan Net - Total HPP</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <?php
                                $total = isset($data['total_pendapatan']) ? $data['total_pendapatan'] : 0;
                                $tPengeluaran = (isset($data['pengeluaran'][0]['total']) ? $data['pengeluaran'][0]['total'] : 0) + 
                                                (isset($data['pengeluaran_kas'][0]['total']) ? $data['pengeluaran_kas'][0]['total'] : 0) + 
                                                (isset($data['pengeluaran_kas_other'][0]['total']) ? $data['pengeluaran_kas_other'][0]['total'] : 0);
                                $ttotal = $total - $tPengeluaran;
                                
                                function formatNumber($num) {
                                    return $num === null ? '0.00' : number_format($num, 2, ',', '.');
                                }
                            ?>
                            <table id="InvoiceDetails" class="table table-bordered table-striped">
                                <thead>
                                    <tr style="background-color: #f2f2f2;">
                                        <th>Deskripsi</th>
                                        <th></th>
                                        <th class="text-right">Nilai (Rp)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr style="background-color: #e6f7ff;">
                                        <td><strong>OMZET/PENDAPATAN BY FAKTUR PENJUALAN</strong></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Penjualan Part</td>
                                        <td class="text-right"><?= formatNumber(isset($data['pendapatan'][0]['part']) ? $data['pendapatan'][0]['part'] : 0) ?></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Pendapatan Jasa</td>
                                        <td class="text-right"><?= formatNumber(isset($data['pendapatan'][0]['jasa']) ? $data['pendapatan'][0]['jasa'] : 0) ?></td>
                                    </tr>
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Total</strong></td>
                                        <td class="text-right"><strong><?= formatNumber($total) ?></strong></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Diskon</td>
                                        <td class="text-right"><?= formatNumber(isset($data['total_diskon']) ? $data['total_diskon'] : 0) ?></td>
                                    </tr>
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Pendapatan(Jasa + Part(- Diskon)</strong></td>
                                        <td class="text-right"><strong><?= formatNumber(isset($data['pendapatan_net']) ? $data['pendapatan_net'] : 0) ?></strong></td>
                                    </tr>

                                    <!-- HPP Part and Jasa Rows -->
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Total HPP Part</strong></td>
                                        <td class="text-right"><strong><?= formatNumber(isset($data['total_hpp_part']) ? $data['total_hpp_part'] : 0) ?></strong></td>
                                    </tr>

                                    <!-- New Row for Total HPP Jasa -->
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Total HPP Jasa</strong></td>
                                        <td class="text-right"><strong><?= formatNumber(isset($data['total_hpp_jasa']) ? $data['total_hpp_jasa'] : 0) ?></strong></td>
                                    </tr>

                                    <!-- Total HPP Row -->
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Total HPP (Part + Jasa)</strong></td>
                                        <td class="text-right"><strong><?= formatNumber(isset($data['total_hpp']) ? $data['total_hpp'] : 0) ?></strong></td>
                                    </tr>

                                    <!-- New Row for HPP GLOBAL -->
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>HPP GLOBAL</strong></td>
                                        <td class="text-right"><strong><?= formatNumber(isset($data['hpp_global']) ? $data['hpp_global'] : 0) ?></strong></td>
                                    </tr>

                                    <!-- Profit Row -->
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Profit</strong></td>
                                        <td class="text-right"><strong><?= formatNumber(isset($data['profit']) ? $data['profit'] : 0) ?></strong></td>
                                    </tr>

                                    <!-- Pengeluaran Rows -->
                                    <tr style="background-color: #e6f7ff;">
                                        <td><strong>PENGELUARAN BY FAKTUR PEMBELIAN DAN KAS</strong></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Pembelian Part</td>
                                        <td class="text-right"><?= formatNumber(isset($data['pengeluaran'][0]['total']) ? $data['pengeluaran'][0]['total'] : 0) ?></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Pengeluaran Kas Bengkel</td>
                                        <td class="text-right"><?= formatNumber(isset($data['pengeluaran_kas'][0]['total']) ? $data['pengeluaran_kas'][0]['total'] : 0) ?></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>Lain - Lain</td>
                                        <td class="text-right"><?= formatNumber(isset($data['pengeluaran_kas_other'][0]['total']) ? $data['pengeluaran_kas_other'][0]['total'] : 0) ?></td>
                                    </tr>
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Total Pengeluaran</strong></td>
                                        <td class="text-right"><strong><?= formatNumber($tPengeluaran) ?></strong></td>
                                    </tr>
                                    <tr>
                                        <td height="20px"></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr style="background-color: #e6f7ff;">
                                        <td></td>
                                        <td><strong>Profit = Total Pendapatan - Total Biaya Pengeluaran</strong></td>
                                        <td class="text-right"><strong><?= formatNumber($ttotal) ?></strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>    
                </div>
            </div>
        </div>
        <!-- row -->
    </div