<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?=$this->Html->link('Home',['plugin'=>'SystemConfigurations','controller'=>'home','action'=>'index'])?></li>
                <li class="breadcrumb-item"><?=$this->Html->link('Report',['plugin'=>'Reports','controller'=>'ReportPenjualanParts','action'=>'index'])?></li>
                <li class="breadcrumb-item"><?=$this->Html->link('Penjualan Part',['plugin'=>'Reports','controller'=>'ReportPenjualanParts','action'=>'index'])?></li>
                <li class="breadcrumb-item active">Index</li>
            </ol>
        </div>
        
        <?php if($this->getRequest()->getSession()->read('Flash')){?>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="alert alert-danger alert-dismissible fade show mb-3"><?= $this->Flash->render() ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></div>
                </div>
            </div>
        <?php } ?>
        
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <!-- Company Info and Date Range -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h4 class="card-title"><?=$company['name']?></h4>
                                <p>Periode: <?=$periode?></p>
                            </div>
                        </div>

                        <!-- Profit Summary Per Mekanik -->
                        <div class="table-responsive mb-5">
                            <h5 class="mb-3">Profit Per Mekanik</h5>
                            <table class="table table-bordered table-striped">
                                <thead style="background-color: #f2f2f2;">
                                    <tr>
                                        <th>Nama Mekanik</th>
                                        <th class="text-end">Omzet Part</th>
                                        <th class="text-end">Omzet Jasa</th>
                                        <th class="text-end">Total Omzet</th>
                                        <th class="text-end">Profit Part</th>
                                        <th class="text-end">Profit Jasa</th>
                                        <th class="text-end">Total Profit</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach($profitPerMekanik as $mekanik): ?>
                                    <tr>
                                        <td><?= $mekanik['nama_mekanik'] ?></td>
                                        <td class="text-end"><?= number_format($mekanik['omzet_part'], 0, ',', '.') ?></td>
                                        <td class="text-end"><?= number_format($mekanik['omzet_jasa'], 0, ',', '.') ?></td>
                                        <td class="text-end"><?= number_format($mekanik['total_omzet'], 0, ',', '.') ?></td>
                                        <td class="text-end"><?= number_format($mekanik['profit_part'], 0, ',', '.') ?></td>
                                        <td class="text-end"><?= number_format($mekanik['profit_jasa'], 0, ',', '.') ?></td>
                                        <td class="text-end"><?= number_format($mekanik['total_profit'], 0, ',', '.') ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                                <tfoot style="background-color: #f2f2f2;">
                                    <tr>
                                        <th class="text-end">Total</th>
                                        <th class="text-end"><?= number_format($totalOmzetPart, 0, ',', '.') ?></th>
                                        <th class="text-end"><?= number_format($totalOmzetJasa, 0, ',', '.') ?></th>
                                        <th class="text-end"><?= number_format($totalOmzet, 0, ',', '.') ?></th>
                                        <th class="text-end"><?= number_format($totalProfitPart, 0, ',', '.') ?></th>
                                        <th class="text-end"><?= number_format($totalProfitJasa, 0, ',', '.') ?></th>
                                        <th class="text-end"><?= number_format($totalProfit, 0, ',', '.') ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- Detail Penjualan Part -->
                        <div class="table-responsive">
                            <h5 class="mb-3">Detail Penjualan Part</h5>
                            <table id="InvoiceDetails" class="table table-bordered table-striped">
                                <thead style="background-color: #f2f2f2;">
                                    <tr class="active">
                                        <th>Tanggal</th>
                                        <th>No Transaksi</th>
                                        <th>Nopol</th>
                                        <th>Mekanik</th>
                                        <th>No Part</th>
                                        <th>Nama Part</th>
                                        <th>Qty</th>
                                        <th class="text-end">Harga Per Item</th>
                                        <th class="text-end">Diskon</th>
                                        <th class="text-end">Harga Total</th>
                                        <th class="text-end">HPP Part</th>
                                        <th class="text-end">Profit Part</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $totalHarga = 0;
                                    $totalHPP = 0;
                                    $totalProfitPartDetail = 0;
                                    foreach($result as $i=>$v){
                                        $totalHarga += $v['total_harga'];
                                        $totalHPP += $v['total_hpp'];
                                        $totalProfitPartDetail += $v['profit'];
                                    ?>
                                        <tr>
                                            <td><?= $v['trans_date'] ?></td>
                                            <td><?= $v['kode_workshop'] ?></td>
                                            <td><?= $v['nopol'] ?></td>
                                            <td><?= $v['nama_mekanik'] ?></td>
                                            <td><?= $v['partnumber'] ?></td>
                                            <td><?= $v['partdesc'] ?></td>
                                            <td><?= $v['total_qty'] ?></td>
                                            <td class="text-end"><?= isset($v['price']) ? number_format($v['price']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['diskon']) ? number_format($v['diskon']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['total_harga']) ? number_format($v['total_harga']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['total_hpp']) ? number_format($v['total_hpp']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['profit']) ? number_format($v['profit']) : '' ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot style="background-color: #f2f2f2;">
                                    <tr>
                                        <th colspan="9" class="text-end">Total</th>
                                        <th class="text-end"><?= number_format($totalHarga) ?></th>
                                        <th class="text-end"><?= number_format($totalHPP) ?></th>
                                        <th class="text-end"><?= number_format($totalProfitPartDetail) ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- Grand Total Summary -->
                        <div class="mt-4 p-3 bg-light rounded">
                            <div class="row">
                                <div class="col-md-3">
                                    <p><strong>Total Omzet Part:</strong> <?= number_format($totalOmzetPart) ?></p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Total Omzet Jasa:</strong> <?= number_format($totalOmzetJasa) ?></p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Total Omzet:</strong> <?= number_format($totalOmzet) ?></p>
                                </div>
                                <div class="col-md-3">
                                    <p><strong>Total Profit:</strong> <?= number_format($totalProfit) ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>