<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Font;

$fileName = 'report-penjualan-part.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set the title and company information
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', $company['address']);
$sheet->setCellValue('A4', 'Report Penjualan Part');
$sheet->setCellValue('A5', 'Tanggal');
$sheet->setCellValue('B5', $periode);

// Set the headers
$row = 7;
$headers = ['Tanggal', 'Kode Transaksi', 'Nopol', 'Mekanik', 'No Part', 'Nama Part', 'Qty', 'Harga', 'Diskon', 'Total Harga', 'Total HPP', 'Profit'];
$headerFill = [
    'fillType' => Fill::FILL_SOLID,
    'startColor' => ['argb' => 'FFFF00']
];
foreach ($headers as $col => $header) {
    $sheet->setCellValueByColumnAndRow($col + 1, $row, $header);
    $sheet->getStyleByColumnAndRow($col + 1, $row)->getFont()->setBold(true);
    $sheet->getStyleByColumnAndRow($col + 1, $row)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
    $sheet->getStyleByColumnAndRow($col + 1, $row)->getFill()->applyFromArray($headerFill);
}

// Add the data
$row = 8;
$totalHarga = 0;
$totalHPP = 0;
$totalProfit = 0;
foreach ($result as $i => $v) {
    $sheet->setCellValue('A' . $row, $v['trans_date']);
    $sheet->setCellValue('B' . $row, $v['kode_workshop']);
    $sheet->setCellValue('C' . $row, $v['nopol']);
    $sheet->setCellValue('D' . $row, $v['nama_mekanik']);
    $sheet->setCellValue('E' . $row, $v['partnumber']);
    $sheet->setCellValue('F' . $row, $v['partdesc']);
    $sheet->setCellValue('G' . $row, $v['total_qty']);
    $sheet->setCellValue('H' . $row, $v['price']);
    $sheet->setCellValue('I' . $row, $v['diskon']);
    $sheet->setCellValue('J' . $row, $v['total_harga']);
    $sheet->setCellValue('K' . $row, $v['total_hpp']);
    $sheet->setCellValue('L' . $row, $v['profit']);

    $totalHarga += $v['total_harga'];
    $totalHPP += $v['total_hpp'];
    $totalProfit += $v['profit'];
    $row++;
}

// Add the totals row
$totalsRow = $row + 1;
$sheet->setCellValue('I' . $totalsRow, 'Total');
$sheet->setCellValue('J' . $totalsRow, $totalHarga);
$sheet->setCellValue('K' . $totalsRow, $totalHPP);
$sheet->setCellValue('L' . $totalsRow, $totalProfit);
$sheet->getStyle('I' . $totalsRow . ':L' . $totalsRow)->getFont()->setBold(true);

// Save the workbook to a file
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
$writer->save('php://output');
exit;
?>