<?php
/**
 * @var \App\View\AppView $this
 */
?>
<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $this->Html->link('Home', ['plugin' => 'SystemConfigurations', 'controller' => 'home', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Report', ['plugin' => 'Reports', 'controller' => 'ReportKartuStocks', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Kartu Stock', ['plugin' => 'Reports', 'controller' => 'ReportKartuStocks', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item active">Index</li>
            </ol>
        </div>
        <!-- row -->
        <?php if ($this->getRequest()->getSession()->check('Flash')) { ?>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="alert alert-danger alert-dismissible fade show mb-3">
                        <?= $this->Flash->render() ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></button>
                    </div>
                </div>
            </div>
        <?php } ?>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <?= $this->Form->create(null, ['url' => ['plugin' => 'reports', 'controller' => 'ReportKartuStocks', 'action' => 'index'], 'method' => 'post']) ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label">Periode</label>
                                    <div class="col-sm-2">
                                        <select class="form-control datepicker" type="select" name="month" id="mdate">
                                            <option value='01'>Januari</option>
                                            <option value='02' selected>Februari</option>
                                            <option value='03'>Maret</option>
                                            <option value='04'>April</option>
                                            <option value='05'>Mei</option>
                                            <option value='06'>Juni</option>
                                            <option value='07'>Juli</option>
                                            <option value='08'>Agustus</option>
                                            <option value='09'>September</option>
                                            <option value='10'>Oktober</option>
                                            <option value='11'>November</option>
                                            <option value='12'>Desember</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-2">
                                        <select class="form-control datepicker" type="select" name="year" id="ydate"> <!-- Perbaikan ID -->
                                            <option value='2024'>2024</option>
                                            <option value='2025'>2025</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label">Partnumber</label>
                                    <div class="col-sm-4">
                                        <!-- Gunakan input text biasa untuk autocomplete -->
                                        <?= $this->Form->control('partnumber', [
                                            'label' => false,
                                            'class' => 'form-control', // Hapus class selectpart
                                            'type' => 'text',
                                            'placeholder' => 'Ketik minimal 3 karakter...',
                                            'id' => 'partnumber'
                                        ]); ?>
                                        <!-- Hidden input untuk menyimpan partnumber yang dipilih -->
                                        <?= $this->Form->control('selected_partnumber', [
                                            'type' => 'hidden',
                                            'id' => 'selected_partnumber'
                                        ]); ?>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label">Export</label>
                                    <div class="col-sm-9">
                                        <div class="form-group m-t-15 m-checkbox-inline mb-0 custom-radio-ml">
                                            <div class="radio radio-primary">
                                                <input id="radioinline3" type="radio" name="type" value="html" checked>
                                                <label class="mb-0" for="radioinline3">Html</label>
                                            </div>
                                            <div class="radio radio-primary">
                                                <input id="radioinline1" type="radio" name="type" value="excel">
                                                <label class="mb-0" for="radioinline1">Excel</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-end">
                        <div class="text-start mt-4 mb-3">
                            <button class="btn btn-primary btn-sl-sm me-2" type="submit"><span class="me-2"></span>Export</button>
                        </div>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
        <!-- row -->
    </div>
</div>

<!-- 
URUTAN SANGAT PENTING: 
1. jQuery (DIPERLUKAN OLEH jQuery UI dan Select2) 
2. jQuery UI CSS & JS 
3. Select2 CSS & JS (JIKA MASIH DIGUNAKAN) 
4. Script Custom Anda 
-->

<!-- 1. Muat jQuery terlebih dahulu -->
<?= $this->Html->script('https://code.jquery.com/jquery-3.6.0.min.js') ?>

<!-- 2. Muat jQuery UI CSS & JS -->
<?= $this->Html->css('https://code.jquery.com/ui/1.12.1/themes/ui-lightness/jquery-ui.css') ?>
<?= $this->Html->script('https://code.jquery.com/ui/1.12.1/jquery-ui.min.js') ?>

<!-- 
    3. JIKA Anda masih menggunakan Select2 di tempat lain, muat di sini:
    <?= $this->Html->css('https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css') ?>
    <?= $this->Html->script('https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.full.min.js') ?>
-->

<?php
// 4. Script Custom Anda - Sekarang jQuery sudah pasti tersedia
$this->Html->scriptStart(['block' => 'scriptBottom']);
?>
$(document).ready(function() {
    // Inisialisasi Autocomplete pada input partnumber
    $("#partnumber").autocomplete({ // Pastikan ID ini sesuai dengan input Anda
        delay: 500,
        minLength: 3,
        source: function(request, response) {
            $.ajax({
                url: "<?= $this->Url->build('/masters/parts/getpartdetail', ['fullBase' => true]) ?>",
                dataType: "json",
                data: {
                    term: request.term
                },
                success: function(data) {
                    // Format data untuk autocomplete
                    var formattedData = $.map(data, function(item) {
                        return {
                            label: item.text, // Teks yang ditampilkan
                            value: item.text, // Nilai yang akan dimasukkan ke input
                            id: item.id       // ID partnumber (disimpan di hidden input)
                        };
                    });
                    response(formattedData);
                },
                error: function() {
                    response([]);
                }
            });
        },
        select: function(event, ui) {
            // Saat item dipilih, simpan ID partnumber di hidden input
            $("#selected_partnumber").val(ui.item.id);
            // console.log("Selected ID: " + ui.item.id + ", Text: " + ui.item.value);
        }
    });
});
<?php
$this->Html->scriptEnd();
?>