<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
$fileName='report-harian-bengkel.xlsx';

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', $company['address']);
$sheet->setCellValue('A4', 'Report Harian Bengkel');
$sheet->setCellValue('A5', 'Tanggal');
$sheet->setCellValue('B5', $periode);

$sheet->mergeCells('A2:H2');
$sheet->mergeCells('B5:D5');
foreach (range('A', 'M') as $columnID) { $sheet->getColumnDimension($columnID)->setAutoSize(true);}

$row=7;
$sheet->setCellValue('A'.$row, 'Tanggal');
$sheet->setCellValue('B'.$row, 'Kode Invoice');
$sheet->setCellValue('C'.$row, 'Nopol');
$sheet->setCellValue('D'.$row, 'Type Service');
$sheet->setCellValue('E'.$row, 'Tipe Motor');
/*$sheet->setCellValue('F'.$row, 'No Telp');*/
$sheet->setCellValue('F'.$row, 'Mekanik');
$sheet->setCellValue('G'.$row, 'Tipe Bayar');
$sheet->setCellValue('H'.$row, 'Total Cash');
$sheet->setCellValue('I'.$row, 'Total QRIS');
$sheet->setCellValue('J'.$row, 'Total EDC');
$sheet->setCellValue('K'.$row, 'Total Transfer');
$sheet->setCellValue('L'.$row, 'Piutang');
$sheet->setCellValue('M'.$row, 'Total');

$sheet->getStyle('A1:M7')->getFont()->setBold(true);



$row=$rowheader=8;
foreach($result as $i=>$v){
    $total = ($v['total_jasa'] + $v['total_part']) - $v['disc'];
	//$listpayment = ['Cash','QRIS','Transfer Bank','EDC/CARD','Piutang'];   
	switch ($v['tipe_bayar']) {
		case 0:
			$tcash=$total;
			$tqris=0;
			$tedc=0;
			$ttransfer=0;
			$tpiutang=0;
			break;
		case 1:
			$tcash=0;
			$tqris=$total;
			$tedc=0;
			$ttransfer=0;
			$tpiutang=0;
			break;
		case 2:
			$tcash=0;
			$tqris=0;
			$tedc=0;
			$ttransfer=$total;
			$tpiutang=0;
			break;
		case 3:
			$tcash=0;
			$tqris=0;
			$tedc=$total;
			$ttransfer=0;
			$tpiutang=0;
			break;
		case 4:
			$tcash=0;
			$tqris=0;
			$tedc=0;
			$ttransfer=0;
			$tpiutang=$total;
			break;
		
		default:
			$tcash=$total;
			$tqris=0;
			$tedc=0;
			$ttransfer=0;
			$tpiutang=0;
	}
	$sheet->setCellValue('A'.$row, $v['trans_date']);
	$sheet->setCellValue('B'.$row, $v['kode_workshop']);
	$sheet->setCellValue('C'.$row, $v['nopol']);
	$sheet->setCellValue('D'.$row, $v['nama_jasa']);
	$sheet->setCellValue('E'.$row, $v['type_mtr']);
/*	$sheet->setCellValue('F'.$row, $v['no_tlp']);*/
	$sheet->setCellValue('F'.$row, $v['nama_mekanik']);
	$sheet->setCellValue('G'.$row, $listpayment[$v['tipe_bayar']]);
	$sheet->setCellValue('H'.$row, $tcash);
	$sheet->setCellValue('I'.$row, $tqris);
	$sheet->setCellValue('J'.$row, $tedc);
	$sheet->setCellValue('K'.$row, $ttransfer);
	$sheet->setCellValue('L'.$row, $tpiutang);
	$sheet->setCellValue('M'.$row, $total);
	$row++;
}
$rowbottom=$row-1;
$sheet->setCellValue('G'.$row, 'Total');
$sheet->setCellValue('H'.$row, '=sum(H'.$rowheader.':H'.$rowbottom.')');
$sheet->setCellValue('I'.$row, '=sum(I'.$rowheader.':I'.$rowbottom.')');
$sheet->setCellValue('J'.$row, '=sum(J'.$rowheader.':J'.$rowbottom.')');
$sheet->setCellValue('K'.$row, '=sum(K'.$rowheader.':K'.$rowbottom.')');
$sheet->setCellValue('L'.$row, '=sum(L'.$rowheader.':L'.$rowbottom.')');
$sheet->setCellValue('M'.$row, '=sum(M'.$rowheader.':M'.$rowbottom.')');



//pr($result); exit;
$row++;
$row++;


$sheet->setCellValue('D'.$row, 'Total UE');
$sheet->setCellValue('E'.$row, sizeof($result));
$sheet->getStyle('D')->getFont()->setBold(true);


$total = ($kas['pendapatan'][0]['jasa']+$kas['pendapatan'][0]['part']) - $kas['pendapatan'][0]['disc'] ;
$tPengeluaran =  $kas['pengeluaran_kas'][0]['total'] + $kas['pengeluaran_kas_other'][0]['total'];
$ttotal = $total - $tPengeluaran ;

$sheet->setCellValue('A'.$row, 'Pendapatan Cash');
$sheet->getStyle('A'.$row)->getFont()->setBold(true);
$row++;
$sheet->setCellValue('A'.$row, 'Jasa Cash');
$sheet->setCellValue('B'.$row, $kas['pendapatan'][0]['jasa']);
$row++;

$sheet->setCellValue('A'.$row, 'Part Cash');
$sheet->setCellValue('B'.$row, $kas['pendapatan'][0]['part']);
$row++;

$sheet->setCellValue('A'.$row, 'Disk TipeBayar Cash');
$sheet->setCellValue('B'.$row, $kas['pendapatan'][0]['disc']);
$row++;

$sheet->setCellValue('A'.$row, 'Pengeluaran Kas');
$sheet->getStyle('A'.$row)->getFont()->setBold(true);
$row++;

$sheet->setCellValue('A'.$row, 'Kas Kecil');
$sheet->setCellValue('B'.$row, $kas['pengeluaran_kas'][0]['total']);
$row++;

$sheet->setCellValue('A'.$row, 'Other');
$sheet->setCellValue('B'.$row, $kas['pengeluaran_kas_other'][0]['total']);
$row++;



$sheet->setCellValue('A'.$row, 'Setoran CASH');
$sheet->setCellValue('B'.$row, $ttotal);
$sheet->getStyle('A'.$row)->getFont()->setBold(true);
$sheet->getStyle('B'.$row)->getFont()->setBold(true);

$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
exit;
?>
